/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.group;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableNoTenantIdEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.group.ConfigurationDeserializer;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityGroup
extends BaseData<EntityGroupId>
implements HasName,
HasOwnerId,
ExportableNoTenantIdEntity<EntityGroupId> {
    private static final long serialVersionUID = 2807349040519543363L;
    public static final EntityType[] groupTypes = new EntityType[]{EntityType.USER, EntityType.CUSTOMER, EntityType.DEVICE, EntityType.ASSET, EntityType.ENTITY_VIEW, EntityType.EDGE, EntityType.DASHBOARD};
    public static final EntityType[] sharableGroupTypes = new EntityType[]{EntityType.CUSTOMER, EntityType.DEVICE, EntityType.ASSET, EntityType.ENTITY_VIEW, EntityType.DASHBOARD, EntityType.EDGE};
    public static final String GROUP_ALL_NAME = "All";
    public static final String GROUP_TENANT_USERS_NAME = "Tenant Users";
    public static final String GROUP_TENANT_ADMINS_NAME = "Tenant Administrators";
    public static final String GROUP_CUSTOMER_USERS_NAME = "Customer Users";
    public static final String GROUP_CUSTOMER_ADMINS_NAME = "Customer Administrators";
    public static final String GROUP_PUBLIC_USERS_NAME = "Public Users";
    public static final String GROUP_EDGE_ALL_STARTS_WITH = "[Edge]";
    public static final String GROUP_EDGE_ALL_ENDS_WITH = "All";
    public static final String GROUP_EDGE_ALL_NAME_PATTERN = "[Edge] %s All";
    public static final String ENTITY_GROUP_TYPE_ALLOWABLE_VALUES = "CUSTOMER,ASSET,DEVICE,USER,ENTITY_VIEW,DASHBOARD,EDGE";
    public static final String EDGE_ENTITY_GROUP_TYPE_ALLOWABLE_VALUES = "ASSET,DEVICE,USER,ENTITY_VIEW,DASHBOARD";
    public static final String SPARKLING_AUTOGENERATED_GROUP_DESCRIPTION = "Autogenerated group for Sparkplug devices";
    @ApiModelProperty(position=5, required=true, allowableValues="CUSTOMER,ASSET,DEVICE,USER,ENTITY_VIEW,DASHBOARD,EDGE")
    private EntityType type;
    @ApiModelProperty(position=4, required=true, value="Name of the entity group", example="Water meters")
    @NoXss
    @Length(fieldName="name")
    private String name;
    @ApiModelProperty(position=3, value="JSON object with the owner of the group - Tenant or Customer Id.")
    private EntityId ownerId;
    @NoXss
    @ApiModelProperty(position=6, value="Arbitrary JSON with additional information about the group")
    @JsonDeserialize(using=ConfigurationDeserializer.class)
    private JsonNode additionalInfo;
    @ApiModelProperty(position=7, value="JSON with the configuration for UI components: list of columns, settings, actions, etc ")
    @JsonDeserialize(using=ConfigurationDeserializer.class)
    private JsonNode configuration;
    private EntityGroupId externalId;

    public EntityGroup(EntityGroupId id) {
        super(id);
    }

    public EntityGroup(EntityGroup entityGroup) {
        super(entityGroup);
        this.type = entityGroup.getType();
        this.name = entityGroup.getName();
        this.ownerId = entityGroup.getOwnerId();
        this.additionalInfo = entityGroup.getAdditionalInfo();
        this.configuration = entityGroup.getConfiguration();
        this.externalId = entityGroup.getExternalId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public EntityId getOwnerId() {
        return this.ownerId;
    }

    @ApiModelProperty(position=8, value="Indicates special group 'All' that contains all entities and can't be deleted.")
    public boolean isGroupAll() {
        return "All".equals(this.name);
    }

    @ApiModelProperty(position=9, value="Indicates special edge group 'All' that contains all entities and can't be deleted.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public boolean isEdgeGroupAll() {
        return EdgeUtils.isEdgeGroupAll(this.name);
    }

    @JsonIgnore
    public boolean isPublic() {
        if (this.getAdditionalInfo() != null && this.getAdditionalInfo().has("isPublic")) {
            return this.getAdditionalInfo().get("isPublic").asBoolean();
        }
        return false;
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the entity group creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the EntityGroupId Id. Specify this field to update the Entity Group. Referencing non-existing Entity Group Id will cause error. Omit this field to create new Entity Group.")
    public EntityGroupId getId() {
        return (EntityGroupId)super.getId();
    }

    public EntityType getType() {
        return this.type;
    }

    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public EntityGroupId getExternalId() {
        return this.externalId;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOwnerId(EntityId ownerId) {
        this.ownerId = ownerId;
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setExternalId(EntityGroupId externalId) {
        this.externalId = externalId;
    }

    @Override
    public String toString() {
        return "EntityGroup(type=" + this.getType() + ", name=" + this.getName() + ", ownerId=" + this.getOwnerId() + ", additionalInfo=" + this.getAdditionalInfo() + ", configuration=" + this.getConfiguration() + ", externalId=" + this.getExternalId() + ")";
    }

    public EntityGroup() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityGroup)) {
            return false;
        }
        EntityGroup other = (EntityGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EntityId this$ownerId = this.getOwnerId();
        EntityId other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        EntityGroupId this$externalId = this.getExternalId();
        EntityGroupId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityGroup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EntityId $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        EntityGroupId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

