/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class RawDataEvent
extends Event {
    private String uuid;
    private String messageType;
    private String message;

    public RawDataEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String uuid, String messageType, String message) {
        super(tenantId, entityId, serviceId, id, ts);
        this.uuid = uuid;
        this.messageType = messageType;
        this.message = message;
    }

    @Override
    public EventType getType() {
        return EventType.RAW_DATA;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        eventInfo.setUid(this.uuid);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        RawDataEvent.putNotNull(json, "uuid", this.uuid);
        RawDataEvent.putNotNull(json, "messageType", this.messageType);
        RawDataEvent.putNotNull(json, "message", this.message);
        return eventInfo;
    }

    public static RawDataEventBuilder builder() {
        return new RawDataEventBuilder();
    }

    @Override
    public String toString() {
        return "RawDataEvent(uuid=" + this.getUuid() + ", messageType=" + this.getMessageType() + ", message=" + this.getMessage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataEvent)) {
            return false;
        }
        RawDataEvent other = (RawDataEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RawDataEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class RawDataEventBuilder {
        private TenantId tenantId;
        private UUID entityId;
        private String serviceId;
        private UUID id;
        private long ts;
        private String uuid;
        private String messageType;
        private String message;

        RawDataEventBuilder() {
        }

        public RawDataEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RawDataEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        public RawDataEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public RawDataEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public RawDataEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        public RawDataEventBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public RawDataEventBuilder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public RawDataEventBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RawDataEvent build() {
            return new RawDataEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.uuid, this.messageType, this.message);
        }

        public String toString() {
            return "RawDataEvent.RawDataEventBuilder(tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", serviceId=" + this.serviceId + ", id=" + this.id + ", ts=" + this.ts + ", uuid=" + this.uuid + ", messageType=" + this.messageType + ", message=" + this.message + ")";
        }
    }
}

