/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edge;

import org.thingsboard.server.common.data.EntityType;

public enum EdgeEventType {
    DASHBOARD(false, EntityType.DASHBOARD),
    ASSET(false, EntityType.ASSET),
    DEVICE(false, EntityType.DEVICE),
    DEVICE_PROFILE(true, EntityType.DEVICE_PROFILE),
    ASSET_PROFILE(true, EntityType.ASSET_PROFILE),
    ENTITY_VIEW(false, EntityType.ENTITY_VIEW),
    ALARM(false, EntityType.ALARM),
    RULE_CHAIN(false, EntityType.RULE_CHAIN),
    RULE_CHAIN_METADATA(false, null),
    EDGE(false, EntityType.EDGE),
    USER(false, EntityType.USER),
    CUSTOMER(true, EntityType.CUSTOMER),
    RELATION(true, null),
    TENANT(true, EntityType.TENANT),
    TENANT_PROFILE(true, EntityType.TENANT_PROFILE),
    WIDGETS_BUNDLE(true, EntityType.WIDGETS_BUNDLE),
    WIDGET_TYPE(true, EntityType.WIDGET_TYPE),
    ADMIN_SETTINGS(true, null),
    OTA_PACKAGE(true, EntityType.OTA_PACKAGE),
    QUEUE(true, EntityType.QUEUE),
    ENTITY_GROUP(false, EntityType.ENTITY_GROUP),
    SCHEDULER_EVENT(false, EntityType.SCHEDULER_EVENT),
    WHITE_LABELING(true, null),
    LOGIN_WHITE_LABELING(true, null),
    CUSTOM_TRANSLATION(true, null),
    ROLE(true, EntityType.ROLE),
    GROUP_PERMISSION(true, EntityType.GROUP_PERMISSION),
    CONVERTER(false, EntityType.CONVERTER),
    INTEGRATION(false, EntityType.INTEGRATION);

    private final boolean allEdgesRelated;
    private final EntityType entityType;

    private EdgeEventType(boolean allEdgesRelated, EntityType entityType) {
        this.allEdgesRelated = allEdgesRelated;
        this.entityType = entityType;
    }

    public boolean isAllEdgesRelated() {
        return this.allEdgesRelated;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }
}

