/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class LwM2MServerSecurityConfig {
    @ApiModelProperty(position=1, value="Server short Id. Used as link to associate server Object Instance. This identifier uniquely identifies each LwM2M Server configured for the LwM2M Client. This Resource MUST be set when the Bootstrap-Server Resource has a value of 'false'. The values ID:0 and ID:65535 values MUST NOT be used for identifying the LwM2M Server.", example="123", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected Integer shortServerId = 123;
    @ApiModelProperty(position=2, value="Is Bootstrap Server or Lwm2m Server. The LwM2M Client MAY be configured to use one or more LwM2M Server Account(s). The LwM2M Client MUST have at most one LwM2M Bootstrap-Server Account. (*) The LwM2M client MUST have at least one LwM2M server account after completing the boot sequence specified.", example="true or false", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected boolean bootstrapServerIs = false;
    @ApiModelProperty(position=3, value="Host for 'No Security' mode", example="0.0.0.0", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected String host;
    @ApiModelProperty(position=4, value="Port for  Lwm2m Server: 'No Security' mode: Lwm2m Server or Bootstrap Server", example="'5685' or '5687'", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected Integer port;
    @ApiModelProperty(position=7, value="Client Hold Off Time. The number of seconds to wait before initiating a Client Initiated Bootstrap once the LwM2M Client has determined it should initiate this bootstrap mode. (This information is relevant for use with a Bootstrap-Server only.)", example="1", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected Integer clientHoldOffTime = 1;
    @ApiModelProperty(position=8, value="Server Public Key for 'Security' mode (DTLS): RPK or X509. Format: base64 encoded", example="MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEAZ0pSaGKHk/GrDaUDnQZpeEdGwX7m3Ws+U/kiVat\n+44sgk3c8g0LotfMpLlZJPhPwJ6ipXV+O1r7IZUjBs3LNA==", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected String serverPublicKey;
    @ApiModelProperty(position=9, value="Server Public Key for 'Security' mode (DTLS): X509. Format: base64 encoded", example="MMIICODCCAd6gAwIBAgIUI88U1zowOdrxDK/dOV+36gJxI2MwCgYIKoZIzj0EAwIwejELMAkGA1UEBhMCVUs\nxEjAQBgNVBAgTCUt5aXYgY2l0eTENMAsGA1UEBxMES3lpdjEUMBIGA1UEChMLVGhpbmdzYm9hcmQxFzAVBgNVBAsMDkRFVkVMT1BFUl9URVNUMRkwFwYDVQQDDBBpbnRlcm1lZGlhdGVfY2EwMB4XDTIyMDEwOTEzMDMwMFoXDTI3MDEwODEzMDMwMFowFDESMBAGA1UEAxM\nJbG9jYWxob3N0MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUO3vBo/JTv0eooY7XHiKAIVDoWKFqtrU7C6q8AIKqpLcqhCdW+haFeBOH3PjY6EwaWkY04Bir4oanU0s7tz2uKOBpzCBpDAOBgNVHQ8BAf8EBAMCBaAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDAYDVR0TAQH/\nBAIwADAdBgNVHQ4EFgQUEjc3Q4a0TxzP/3x3EV4fHxYUg0YwHwYDVR0jBBgwFoAUuSquGycMU6Q0SYNcbtSkSD3TfH0wLwYDVR0RBCgwJoIVbG9jYWxob3N0LmxvY2FsZG9tYWlugglsb2NhbGhvc3SCAiAtMAoGCCqGSM49BAMCA0gAMEUCIQD7dbZObyUaoDiNbX+9fUNp\nAWrD7N7XuJUwZ9FcN75R3gIgb2RNjDkHoyUyF1YajwkBk+7XmIXNClmizNJigj908mw=", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    protected String serverCertificate;
    @ApiModelProperty(position=10, value="Bootstrap Server Account Timeout (If the value is set to 0, or if this resource is not instantiated, the Bootstrap-Server Account lifetime is infinite.)", example="0", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    Integer bootstrapServerAccountTimeout = 0;
    @ApiModelProperty(position=11, value="Specify the lifetime of the registration in seconds.", example="300", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private Integer lifetime = 300;
    @ApiModelProperty(position=12, value="The default value the LwM2M Client should use for the Minimum Period of an Observation in the absence of this parameter being included in an Observation. If this Resource doesn\u2019t exist, the default value is 0.", example="1", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private Integer defaultMinPeriod = 1;
    @ApiModelProperty(position=13, value="If true, the LwM2M Client stores \u201cNotify\u201d operations to the LwM2M Server while the LwM2M Server account is disabled or the LwM2M Client is offline. After the LwM2M Server account is enabled or the LwM2M Client is online, the LwM2M Client reports the stored \u201cNotify\u201d operations to the Server. If false, the LwM2M Client discards all the \u201cNotify\u201d operations or temporarily disables the Observe function while the LwM2M Server is disabled or the LwM2M Client is offline. The default value is true.", example="true", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private boolean notifIfDisabled = true;
    @ApiModelProperty(position=14, value="This Resource defines the transport binding configured for the LwM2M Client. If the LwM2M Client supports the binding specified in this Resource, the LwM2M Client MUST use that transport for the Current Binding Mode.", example="U", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String binding = "U";

    public Integer getShortServerId() {
        return this.shortServerId;
    }

    public boolean isBootstrapServerIs() {
        return this.bootstrapServerIs;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getClientHoldOffTime() {
        return this.clientHoldOffTime;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public Integer getBootstrapServerAccountTimeout() {
        return this.bootstrapServerAccountTimeout;
    }

    public Integer getLifetime() {
        return this.lifetime;
    }

    public Integer getDefaultMinPeriod() {
        return this.defaultMinPeriod;
    }

    public boolean isNotifIfDisabled() {
        return this.notifIfDisabled;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setShortServerId(Integer shortServerId) {
        this.shortServerId = shortServerId;
    }

    public void setBootstrapServerIs(boolean bootstrapServerIs) {
        this.bootstrapServerIs = bootstrapServerIs;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setClientHoldOffTime(Integer clientHoldOffTime) {
        this.clientHoldOffTime = clientHoldOffTime;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public void setBootstrapServerAccountTimeout(Integer bootstrapServerAccountTimeout) {
        this.bootstrapServerAccountTimeout = bootstrapServerAccountTimeout;
    }

    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }

    public void setDefaultMinPeriod(Integer defaultMinPeriod) {
        this.defaultMinPeriod = defaultMinPeriod;
    }

    public void setNotifIfDisabled(boolean notifIfDisabled) {
        this.notifIfDisabled = notifIfDisabled;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MServerSecurityConfig)) {
            return false;
        }
        LwM2MServerSecurityConfig other = (LwM2MServerSecurityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBootstrapServerIs() != other.isBootstrapServerIs()) {
            return false;
        }
        if (this.isNotifIfDisabled() != other.isNotifIfDisabled()) {
            return false;
        }
        Integer this$shortServerId = this.getShortServerId();
        Integer other$shortServerId = other.getShortServerId();
        if (this$shortServerId == null ? other$shortServerId != null : !((Object)this$shortServerId).equals(other$shortServerId)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$clientHoldOffTime = this.getClientHoldOffTime();
        Integer other$clientHoldOffTime = other.getClientHoldOffTime();
        if (this$clientHoldOffTime == null ? other$clientHoldOffTime != null : !((Object)this$clientHoldOffTime).equals(other$clientHoldOffTime)) {
            return false;
        }
        Integer this$bootstrapServerAccountTimeout = this.getBootstrapServerAccountTimeout();
        Integer other$bootstrapServerAccountTimeout = other.getBootstrapServerAccountTimeout();
        if (this$bootstrapServerAccountTimeout == null ? other$bootstrapServerAccountTimeout != null : !((Object)this$bootstrapServerAccountTimeout).equals(other$bootstrapServerAccountTimeout)) {
            return false;
        }
        Integer this$lifetime = this.getLifetime();
        Integer other$lifetime = other.getLifetime();
        if (this$lifetime == null ? other$lifetime != null : !((Object)this$lifetime).equals(other$lifetime)) {
            return false;
        }
        Integer this$defaultMinPeriod = this.getDefaultMinPeriod();
        Integer other$defaultMinPeriod = other.getDefaultMinPeriod();
        if (this$defaultMinPeriod == null ? other$defaultMinPeriod != null : !((Object)this$defaultMinPeriod).equals(other$defaultMinPeriod)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$serverPublicKey = this.getServerPublicKey();
        String other$serverPublicKey = other.getServerPublicKey();
        if (this$serverPublicKey == null ? other$serverPublicKey != null : !this$serverPublicKey.equals(other$serverPublicKey)) {
            return false;
        }
        String this$serverCertificate = this.getServerCertificate();
        String other$serverCertificate = other.getServerCertificate();
        if (this$serverCertificate == null ? other$serverCertificate != null : !this$serverCertificate.equals(other$serverCertificate)) {
            return false;
        }
        String this$binding = this.getBinding();
        String other$binding = other.getBinding();
        return !(this$binding == null ? other$binding != null : !this$binding.equals(other$binding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MServerSecurityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBootstrapServerIs() ? 79 : 97);
        result = result * 59 + (this.isNotifIfDisabled() ? 79 : 97);
        Integer $shortServerId = this.getShortServerId();
        result = result * 59 + ($shortServerId == null ? 43 : ((Object)$shortServerId).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $clientHoldOffTime = this.getClientHoldOffTime();
        result = result * 59 + ($clientHoldOffTime == null ? 43 : ((Object)$clientHoldOffTime).hashCode());
        Integer $bootstrapServerAccountTimeout = this.getBootstrapServerAccountTimeout();
        result = result * 59 + ($bootstrapServerAccountTimeout == null ? 43 : ((Object)$bootstrapServerAccountTimeout).hashCode());
        Integer $lifetime = this.getLifetime();
        result = result * 59 + ($lifetime == null ? 43 : ((Object)$lifetime).hashCode());
        Integer $defaultMinPeriod = this.getDefaultMinPeriod();
        result = result * 59 + ($defaultMinPeriod == null ? 43 : ((Object)$defaultMinPeriod).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $serverPublicKey = this.getServerPublicKey();
        result = result * 59 + ($serverPublicKey == null ? 43 : $serverPublicKey.hashCode());
        String $serverCertificate = this.getServerCertificate();
        result = result * 59 + ($serverCertificate == null ? 43 : $serverCertificate.hashCode());
        String $binding = this.getBinding();
        result = result * 59 + ($binding == null ? 43 : $binding.hashCode());
        return result;
    }

    public String toString() {
        return "LwM2MServerSecurityConfig(shortServerId=" + this.getShortServerId() + ", bootstrapServerIs=" + this.isBootstrapServerIs() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", clientHoldOffTime=" + this.getClientHoldOffTime() + ", serverPublicKey=" + this.getServerPublicKey() + ", serverCertificate=" + this.getServerCertificate() + ", bootstrapServerAccountTimeout=" + this.getBootstrapServerAccountTimeout() + ", lifetime=" + this.getLifetime() + ", defaultMinPeriod=" + this.getDefaultMinPeriod() + ", notifIfDisabled=" + this.isNotifIfDisabled() + ", binding=" + this.getBinding() + ")";
    }
}

