/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.transport.snmp.config.SnmpCommunicationConfig;

public class SnmpDeviceProfileTransportConfiguration
implements DeviceProfileTransportConfiguration {
    private Integer timeoutMs;
    private Integer retries;
    private List<SnmpCommunicationConfig> communicationConfigs;

    @Override
    public DeviceTransportType getType() {
        return DeviceTransportType.SNMP;
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("SNMP transport configuration is not valid");
        }
    }

    @JsonIgnore
    private boolean isValid() {
        return this.timeoutMs != null && this.timeoutMs >= 0 && this.retries != null && this.retries >= 0 && this.communicationConfigs != null && this.communicationConfigs.stream().allMatch(config -> config != null && config.isValid());
    }

    public Integer getTimeoutMs() {
        return this.timeoutMs;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public List<SnmpCommunicationConfig> getCommunicationConfigs() {
        return this.communicationConfigs;
    }

    public void setTimeoutMs(Integer timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public void setCommunicationConfigs(List<SnmpCommunicationConfig> communicationConfigs) {
        this.communicationConfigs = communicationConfigs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpDeviceProfileTransportConfiguration)) {
            return false;
        }
        SnmpDeviceProfileTransportConfiguration other = (SnmpDeviceProfileTransportConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$timeoutMs = this.getTimeoutMs();
        Integer other$timeoutMs = other.getTimeoutMs();
        if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
            return false;
        }
        Integer this$retries = this.getRetries();
        Integer other$retries = other.getRetries();
        if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
            return false;
        }
        List<SnmpCommunicationConfig> this$communicationConfigs = this.getCommunicationConfigs();
        List<SnmpCommunicationConfig> other$communicationConfigs = other.getCommunicationConfigs();
        return !(this$communicationConfigs == null ? other$communicationConfigs != null : !((Object)this$communicationConfigs).equals(other$communicationConfigs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnmpDeviceProfileTransportConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $timeoutMs = this.getTimeoutMs();
        result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
        Integer $retries = this.getRetries();
        result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
        List<SnmpCommunicationConfig> $communicationConfigs = this.getCommunicationConfigs();
        result = result * 59 + ($communicationConfigs == null ? 43 : ((Object)$communicationConfigs).hashCode());
        return result;
    }

    public String toString() {
        return "SnmpDeviceProfileTransportConfiguration(timeoutMs=" + this.getTimeoutMs() + ", retries=" + this.getRetries() + ", communicationConfigs=" + this.getCommunicationConfigs() + ")";
    }
}

