/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.audit;

import java.util.Optional;
import org.thingsboard.server.common.data.msg.TbMsgType;

public enum ActionType {
    ADDED(false, TbMsgType.ENTITY_CREATED),
    DELETED(false, TbMsgType.ENTITY_DELETED),
    UPDATED(false, TbMsgType.ENTITY_UPDATED),
    ATTRIBUTES_UPDATED(false, TbMsgType.ATTRIBUTES_UPDATED),
    ATTRIBUTES_DELETED(false, TbMsgType.ATTRIBUTES_DELETED),
    TIMESERIES_UPDATED(false, TbMsgType.TIMESERIES_UPDATED),
    TIMESERIES_DELETED(false, TbMsgType.TIMESERIES_DELETED),
    RPC_CALL(false, null),
    CREDENTIALS_UPDATED(false, null),
    ASSIGNED_TO_CUSTOMER(false, TbMsgType.ENTITY_ASSIGNED),
    UNASSIGNED_FROM_CUSTOMER(false, TbMsgType.ENTITY_UNASSIGNED),
    CHANGE_OWNER(false, TbMsgType.OWNER_CHANGED),
    ACTIVATED(false, null),
    SUSPENDED(false, null),
    CREDENTIALS_READ(true, null),
    ATTRIBUTES_READ(true, null),
    RELATION_ADD_OR_UPDATE(false, TbMsgType.RELATION_ADD_OR_UPDATE),
    RELATION_DELETED(false, TbMsgType.RELATION_DELETED),
    RELATIONS_DELETED(false, TbMsgType.RELATIONS_DELETED),
    ALARM_ACK(false, TbMsgType.ALARM_ACK),
    ALARM_CLEAR(false, TbMsgType.ALARM_CLEAR),
    ALARM_DELETE(false, TbMsgType.ALARM_DELETE),
    ALARM_ASSIGNED(false, TbMsgType.ALARM_ASSIGNED),
    ALARM_UNASSIGNED(false, TbMsgType.ALARM_UNASSIGNED),
    ADDED_TO_ENTITY_GROUP(false, TbMsgType.ADDED_TO_ENTITY_GROUP),
    REMOVED_FROM_ENTITY_GROUP(false, TbMsgType.REMOVED_FROM_ENTITY_GROUP),
    REST_API_RULE_ENGINE_CALL(false, null),
    MADE_PUBLIC(false, null),
    MADE_PRIVATE(false, null),
    LOGIN(false, null),
    LOGOUT(false, null),
    LOCKOUT(false, null),
    ASSIGNED_FROM_TENANT(false, TbMsgType.ENTITY_ASSIGNED_FROM_TENANT),
    ASSIGNED_TO_TENANT(false, TbMsgType.ENTITY_ASSIGNED_TO_TENANT),
    PROVISION_SUCCESS(false, TbMsgType.PROVISION_SUCCESS),
    PROVISION_FAILURE(false, TbMsgType.PROVISION_FAILURE),
    ASSIGNED_TO_EDGE(false, TbMsgType.ENTITY_ASSIGNED_TO_EDGE),
    UNASSIGNED_FROM_EDGE(false, TbMsgType.ENTITY_UNASSIGNED_FROM_EDGE),
    ADDED_COMMENT(false, TbMsgType.COMMENT_CREATED),
    UPDATED_COMMENT(false, TbMsgType.COMMENT_UPDATED),
    DELETED_COMMENT(false, null),
    SMS_SENT(false, null);

    private final boolean isRead;
    private final TbMsgType ruleEngineMsgType;

    private ActionType(boolean isRead, TbMsgType ruleEngineMsgType) {
        this.isRead = isRead;
        this.ruleEngineMsgType = ruleEngineMsgType;
    }

    public Optional<TbMsgType> getRuleEngineMsgType() {
        return Optional.ofNullable(this.ruleEngineMsgType);
    }

    public boolean isRead() {
        return this.isRead;
    }
}

