/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.id.AlarmCommentId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class AlarmComment
extends BaseData<AlarmCommentId>
implements HasName {
    @ApiModelProperty(position=3, value="JSON object with Alarm id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private EntityId alarmId;
    @ApiModelProperty(position=4, value="JSON object with User id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private UserId userId;
    @ApiModelProperty(position=5, value="Defines origination of comment. System type means comment was created by TB. OTHER type means comment was created by user.", example="SYSTEM/OTHER", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private AlarmCommentType type;
    @ApiModelProperty(position=6, value="JSON object with text of comment.", dataType="com.fasterxml.jackson.databind.JsonNode")
    @NoXss
    @Length(fieldName="comment", max=10000)
    private transient JsonNode comment;

    @Override
    @ApiModelProperty(position=1, value="JSON object with the alarm comment Id. Specify this field to update the alarm comment. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.")
    public AlarmCommentId getId() {
        return (AlarmCommentId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the alarm comment creation, in milliseconds", example="1634058704567", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    public AlarmComment() {
    }

    public AlarmComment(AlarmCommentId id) {
        super(id);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(position=5, required=true, value="representing comment text", example="Please take a look")
    public String getName() {
        return this.comment.toString();
    }

    public AlarmComment(AlarmComment alarmComment) {
        super(alarmComment.getId());
        this.createdTime = alarmComment.getCreatedTime();
        this.alarmId = alarmComment.getAlarmId();
        this.type = alarmComment.getType();
        this.comment = alarmComment.getComment();
        this.userId = alarmComment.getUserId();
    }

    public static AlarmCommentBuilder builder() {
        return new AlarmCommentBuilder();
    }

    public EntityId getAlarmId() {
        return this.alarmId;
    }

    public UserId getUserId() {
        return this.userId;
    }

    public AlarmCommentType getType() {
        return this.type;
    }

    public JsonNode getComment() {
        return this.comment;
    }

    public void setAlarmId(EntityId alarmId) {
        this.alarmId = alarmId;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public void setType(AlarmCommentType type) {
        this.type = type;
    }

    public void setComment(JsonNode comment) {
        this.comment = comment;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmComment)) {
            return false;
        }
        AlarmComment other = (AlarmComment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$alarmId = this.getAlarmId();
        EntityId other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !this$alarmId.equals(other$alarmId)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        AlarmCommentType this$type = this.getType();
        AlarmCommentType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JsonNode this$comment = this.getComment();
        JsonNode other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmComment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : $alarmId.hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        AlarmCommentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JsonNode $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AlarmComment(alarmId=" + this.getAlarmId() + ", userId=" + this.getUserId() + ", type=" + this.getType() + ", comment=" + this.getComment() + ")";
    }

    @ConstructorProperties(value={"alarmId", "userId", "type", "comment"})
    public AlarmComment(EntityId alarmId, UserId userId, AlarmCommentType type, JsonNode comment) {
        this.alarmId = alarmId;
        this.userId = userId;
        this.type = type;
        this.comment = comment;
    }

    public static class AlarmCommentBuilder {
        private EntityId alarmId;
        private UserId userId;
        private AlarmCommentType type;
        private JsonNode comment;

        AlarmCommentBuilder() {
        }

        public AlarmCommentBuilder alarmId(EntityId alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public AlarmCommentBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        public AlarmCommentBuilder type(AlarmCommentType type) {
            this.type = type;
            return this;
        }

        public AlarmCommentBuilder comment(JsonNode comment) {
            this.comment = comment;
            return this;
        }

        public AlarmComment build() {
            return new AlarmComment(this.alarmId, this.userId, this.type, this.comment);
        }

        public String toString() {
            return "AlarmComment.AlarmCommentBuilder(alarmId=" + this.alarmId + ", userId=" + this.userId + ", type=" + this.type + ", comment=" + this.comment + ")";
        }
    }
}

