/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
@JsonIgnoreProperties(ignoreUnknown=true)
public class Alarm
extends BaseData<AlarmId>
implements HasName,
TenantEntity,
HasCustomerId {
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Customer Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @ApiModelProperty(position=6, required=true, value="representing type of the Alarm", example="High Temperature Alarm")
    @Length(fieldName="type")
    private String type;
    @ApiModelProperty(position=7, required=true, value="JSON object with alarm originator id")
    private EntityId originator;
    @ApiModelProperty(position=8, required=true, value="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @ApiModelProperty(position=9, required=true, value="Acknowledged", example="true")
    private boolean acknowledged;
    @ApiModelProperty(position=10, required=true, value="Cleared", example="false")
    private boolean cleared;
    @ApiModelProperty(position=11, value="Alarm assignee user id")
    private UserId assigneeId;
    @ApiModelProperty(position=12, value="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @ApiModelProperty(position=13, value="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @ApiModelProperty(position=14, value="Timestamp of the alarm acknowledgement, in milliseconds", example="1634115221948")
    private long ackTs;
    @ApiModelProperty(position=15, value="Timestamp of the alarm clearing, in milliseconds", example="1634114528465")
    private long clearTs;
    @ApiModelProperty(position=16, value="Timestamp of the alarm assignment, in milliseconds", example="1634115928465")
    private long assignTs;
    @ApiModelProperty(position=17, value="JSON object with alarm details")
    private transient JsonNode details;
    @ApiModelProperty(position=18, value="Propagation flag to specify if alarm should be propagated to parent entities of alarm originator", example="true")
    private boolean propagate;
    @ApiModelProperty(position=19, value="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) of alarm originator", example="true")
    private boolean propagateToOwner;
    @ApiModelProperty(position=17, value="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) and all parent owners in the customer hierarchy", example="true")
    private boolean propagateToOwnerHierarchy;
    @ApiModelProperty(position=18, value="Propagation flag to specify if alarm should be propagated to the tenant entity", example="true")
    private boolean propagateToTenant;
    @ApiModelProperty(position=19, value="JSON array of relation types that should be used for propagation. By default, 'propagateRelationTypes' array is empty which means that the alarm will be propagated based on any relation type to parent entities. This parameter should be used only in case when 'propagate' parameter is set to true, otherwise, 'propagateRelationTypes' array will be ignored.")
    private List<String> propagateRelationTypes;

    public Alarm() {
    }

    public Alarm(AlarmId id) {
        super(id);
    }

    public Alarm(Alarm alarm) {
        super(alarm.getId());
        this.createdTime = alarm.getCreatedTime();
        this.tenantId = alarm.getTenantId();
        this.customerId = alarm.getCustomerId();
        this.type = alarm.getType();
        this.originator = alarm.getOriginator();
        this.severity = alarm.getSeverity();
        this.assigneeId = alarm.getAssigneeId();
        this.startTs = alarm.getStartTs();
        this.endTs = alarm.getEndTs();
        this.acknowledged = alarm.isAcknowledged();
        this.ackTs = alarm.getAckTs();
        this.clearTs = alarm.getClearTs();
        this.cleared = alarm.isCleared();
        this.assignTs = alarm.getAssignTs();
        this.details = alarm.getDetails();
        this.propagate = alarm.isPropagate();
        this.propagateToOwner = alarm.isPropagateToOwner();
        this.propagateToOwnerHierarchy = alarm.isPropagateToOwnerHierarchy();
        this.propagateToTenant = alarm.isPropagateToTenant();
        this.propagateRelationTypes = alarm.getPropagateRelationTypes();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(position=5, required=true, value="representing type of the Alarm", example="High Temperature Alarm")
    public String getName() {
        return this.type;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ALARM;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the alarm Id. Specify this field to update the alarm. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.")
    public AlarmId getId() {
        return (AlarmId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the alarm creation, in milliseconds", example="1634058704567", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(position=22, required=true, value="status of the Alarm", example="ACTIVE_UNACK", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public AlarmStatus getStatus() {
        return Alarm.toStatus(this.cleared, this.acknowledged);
    }

    public static AlarmStatus toStatus(boolean cleared, boolean acknowledged) {
        if (cleared) {
            return acknowledged ? AlarmStatus.CLEARED_ACK : AlarmStatus.CLEARED_UNACK;
        }
        return acknowledged ? AlarmStatus.ACTIVE_ACK : AlarmStatus.ACTIVE_UNACK;
    }

    public static AlarmBuilder builder() {
        return new AlarmBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public String getType() {
        return this.type;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public UserId getAssigneeId() {
        return this.assigneeId;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getAckTs() {
        return this.ackTs;
    }

    public long getClearTs() {
        return this.clearTs;
    }

    public long getAssignTs() {
        return this.assignTs;
    }

    public JsonNode getDetails() {
        return this.details;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public boolean isPropagateToOwner() {
        return this.propagateToOwner;
    }

    public boolean isPropagateToOwnerHierarchy() {
        return this.propagateToOwnerHierarchy;
    }

    public boolean isPropagateToTenant() {
        return this.propagateToTenant;
    }

    public List<String> getPropagateRelationTypes() {
        return this.propagateRelationTypes;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOriginator(EntityId originator) {
        this.originator = originator;
    }

    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public void setAssigneeId(UserId assigneeId) {
        this.assigneeId = assigneeId;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setAckTs(long ackTs) {
        this.ackTs = ackTs;
    }

    public void setClearTs(long clearTs) {
        this.clearTs = clearTs;
    }

    public void setAssignTs(long assignTs) {
        this.assignTs = assignTs;
    }

    public void setDetails(JsonNode details) {
        this.details = details;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setPropagateToOwner(boolean propagateToOwner) {
        this.propagateToOwner = propagateToOwner;
    }

    public void setPropagateToOwnerHierarchy(boolean propagateToOwnerHierarchy) {
        this.propagateToOwnerHierarchy = propagateToOwnerHierarchy;
    }

    public void setPropagateToTenant(boolean propagateToTenant) {
        this.propagateToTenant = propagateToTenant;
    }

    public void setPropagateRelationTypes(List<String> propagateRelationTypes) {
        this.propagateRelationTypes = propagateRelationTypes;
    }

    @Override
    public String toString() {
        return "Alarm(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", type=" + this.getType() + ", originator=" + this.getOriginator() + ", severity=" + this.getSeverity() + ", acknowledged=" + this.isAcknowledged() + ", cleared=" + this.isCleared() + ", assigneeId=" + this.getAssigneeId() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", ackTs=" + this.getAckTs() + ", clearTs=" + this.getClearTs() + ", assignTs=" + this.getAssignTs() + ", details=" + this.getDetails() + ", propagate=" + this.isPropagate() + ", propagateToOwner=" + this.isPropagateToOwner() + ", propagateToOwnerHierarchy=" + this.isPropagateToOwnerHierarchy() + ", propagateToTenant=" + this.isPropagateToTenant() + ", propagateRelationTypes=" + this.getPropagateRelationTypes() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAcknowledged() != other.isAcknowledged()) {
            return false;
        }
        if (this.isCleared() != other.isCleared()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getAckTs() != other.getAckTs()) {
            return false;
        }
        if (this.getClearTs() != other.getClearTs()) {
            return false;
        }
        if (this.getAssignTs() != other.getAssignTs()) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isPropagateToOwner() != other.isPropagateToOwner()) {
            return false;
        }
        if (this.isPropagateToOwnerHierarchy() != other.isPropagateToOwnerHierarchy()) {
            return false;
        }
        if (this.isPropagateToTenant() != other.isPropagateToTenant()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        UserId this$assigneeId = this.getAssigneeId();
        UserId other$assigneeId = other.getAssigneeId();
        if (this$assigneeId == null ? other$assigneeId != null : !((Object)this$assigneeId).equals(other$assigneeId)) {
            return false;
        }
        List<String> this$propagateRelationTypes = this.getPropagateRelationTypes();
        List<String> other$propagateRelationTypes = other.getPropagateRelationTypes();
        return !(this$propagateRelationTypes == null ? other$propagateRelationTypes != null : !((Object)this$propagateRelationTypes).equals(other$propagateRelationTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Alarm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAcknowledged() ? 79 : 97);
        result = result * 59 + (this.isCleared() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $ackTs = this.getAckTs();
        result = result * 59 + (int)($ackTs >>> 32 ^ $ackTs);
        long $clearTs = this.getClearTs();
        result = result * 59 + (int)($clearTs >>> 32 ^ $clearTs);
        long $assignTs = this.getAssignTs();
        result = result * 59 + (int)($assignTs >>> 32 ^ $assignTs);
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwner() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwnerHierarchy() ? 79 : 97);
        result = result * 59 + (this.isPropagateToTenant() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        UserId $assigneeId = this.getAssigneeId();
        result = result * 59 + ($assigneeId == null ? 43 : ((Object)$assigneeId).hashCode());
        List<String> $propagateRelationTypes = this.getPropagateRelationTypes();
        result = result * 59 + ($propagateRelationTypes == null ? 43 : ((Object)$propagateRelationTypes).hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "customerId", "type", "originator", "severity", "acknowledged", "cleared", "assigneeId", "startTs", "endTs", "ackTs", "clearTs", "assignTs", "details", "propagate", "propagateToOwner", "propagateToOwnerHierarchy", "propagateToTenant", "propagateRelationTypes"})
    public Alarm(TenantId tenantId, CustomerId customerId, String type, EntityId originator, AlarmSeverity severity, boolean acknowledged, boolean cleared, UserId assigneeId, long startTs, long endTs, long ackTs, long clearTs, long assignTs, JsonNode details, boolean propagate, boolean propagateToOwner, boolean propagateToOwnerHierarchy, boolean propagateToTenant, List<String> propagateRelationTypes) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.type = type;
        this.originator = originator;
        this.severity = severity;
        this.acknowledged = acknowledged;
        this.cleared = cleared;
        this.assigneeId = assigneeId;
        this.startTs = startTs;
        this.endTs = endTs;
        this.ackTs = ackTs;
        this.clearTs = clearTs;
        this.assignTs = assignTs;
        this.details = details;
        this.propagate = propagate;
        this.propagateToOwner = propagateToOwner;
        this.propagateToOwnerHierarchy = propagateToOwnerHierarchy;
        this.propagateToTenant = propagateToTenant;
        this.propagateRelationTypes = propagateRelationTypes;
    }

    public static class AlarmBuilder {
        private TenantId tenantId;
        private CustomerId customerId;
        private String type;
        private EntityId originator;
        private AlarmSeverity severity;
        private boolean acknowledged;
        private boolean cleared;
        private UserId assigneeId;
        private long startTs;
        private long endTs;
        private long ackTs;
        private long clearTs;
        private long assignTs;
        private JsonNode details;
        private boolean propagate;
        private boolean propagateToOwner;
        private boolean propagateToOwnerHierarchy;
        private boolean propagateToTenant;
        private List<String> propagateRelationTypes;

        AlarmBuilder() {
        }

        public AlarmBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AlarmBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public AlarmBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AlarmBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        public AlarmBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        public AlarmBuilder acknowledged(boolean acknowledged) {
            this.acknowledged = acknowledged;
            return this;
        }

        public AlarmBuilder cleared(boolean cleared) {
            this.cleared = cleared;
            return this;
        }

        public AlarmBuilder assigneeId(UserId assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        public AlarmBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        public AlarmBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        public AlarmBuilder ackTs(long ackTs) {
            this.ackTs = ackTs;
            return this;
        }

        public AlarmBuilder clearTs(long clearTs) {
            this.clearTs = clearTs;
            return this;
        }

        public AlarmBuilder assignTs(long assignTs) {
            this.assignTs = assignTs;
            return this;
        }

        public AlarmBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        public AlarmBuilder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public AlarmBuilder propagateToOwner(boolean propagateToOwner) {
            this.propagateToOwner = propagateToOwner;
            return this;
        }

        public AlarmBuilder propagateToOwnerHierarchy(boolean propagateToOwnerHierarchy) {
            this.propagateToOwnerHierarchy = propagateToOwnerHierarchy;
            return this;
        }

        public AlarmBuilder propagateToTenant(boolean propagateToTenant) {
            this.propagateToTenant = propagateToTenant;
            return this;
        }

        public AlarmBuilder propagateRelationTypes(List<String> propagateRelationTypes) {
            this.propagateRelationTypes = propagateRelationTypes;
            return this;
        }

        public Alarm build() {
            return new Alarm(this.tenantId, this.customerId, this.type, this.originator, this.severity, this.acknowledged, this.cleared, this.assigneeId, this.startTs, this.endTs, this.ackTs, this.clearTs, this.assignTs, this.details, this.propagate, this.propagateToOwner, this.propagateToOwnerHierarchy, this.propagateToTenant, this.propagateRelationTypes);
        }

        public String toString() {
            return "Alarm.AlarmBuilder(tenantId=" + this.tenantId + ", customerId=" + this.customerId + ", type=" + this.type + ", originator=" + this.originator + ", severity=" + this.severity + ", acknowledged=" + this.acknowledged + ", cleared=" + this.cleared + ", assigneeId=" + this.assigneeId + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", ackTs=" + this.ackTs + ", clearTs=" + this.clearTs + ", assignTs=" + this.assignTs + ", details=" + this.details + ", propagate=" + this.propagate + ", propagateToOwner=" + this.propagateToOwner + ", propagateToOwnerHierarchy=" + this.propagateToOwnerHierarchy + ", propagateToTenant=" + this.propagateToTenant + ", propagateRelationTypes=" + this.propagateRelationTypes + ")";
        }
    }
}

