/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class TbResourceInfo
extends BaseData<TbResourceId>
implements HasName,
TenantEntity {
    private static final Logger log = LoggerFactory.getLogger(TbResourceInfo.class);
    private static final long serialVersionUID = 7282664529021651736L;
    @ApiModelProperty(position=3, value="JSON object with Tenant Id. Tenant Id of the resource can't be changed.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="title")
    @ApiModelProperty(position=4, value="Resource title.", example="BinaryAppDataContainer id=19 v1.0")
    private String title;
    @ApiModelProperty(position=5, value="Resource type.", example="LWM2M_MODEL", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private ResourceType resourceType;
    @NoXss
    @Length(fieldName="resourceKey")
    @ApiModelProperty(position=6, value="Resource key.", example="19_1.0", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String resourceKey;
    @ApiModelProperty(position=7, value="Resource search text.", example="19_1.0:binaryappdatacontainer", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String searchText;
    @ApiModelProperty(position=8, value="Resource etag.", example="33a64df551425fcc55e4d42a148795d9f25f89d4", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String etag;

    public TbResourceInfo() {
    }

    public TbResourceInfo(TbResourceId id) {
        super(id);
    }

    public TbResourceInfo(TbResourceInfo resourceInfo) {
        super(resourceInfo);
        this.tenantId = resourceInfo.getTenantId();
        this.title = resourceInfo.getTitle();
        this.resourceType = resourceInfo.getResourceType();
        this.resourceKey = resourceInfo.getResourceKey();
        this.searchText = resourceInfo.getSearchText();
        this.etag = resourceInfo.getEtag();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Resource Id. Specify this field to update the Resource. Referencing non-existing Resource Id will cause error. Omit this field to create new Resource.")
    public TbResourceId getId() {
        return (TbResourceId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the resource creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.title;
    }

    @JsonIgnore
    public String getSearchText() {
        return this.searchText != null ? this.searchText : this.title;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceInfo [tenantId=");
        builder.append(this.tenantId);
        builder.append(", id=");
        builder.append(this.getUuidId());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", resourceType=");
        builder.append((Object)this.resourceType);
        builder.append(", resourceKey=");
        builder.append(this.resourceKey);
        builder.append(", hashCode=");
        builder.append(this.etag);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.TB_RESOURCE;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getTitle() {
        return this.title;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getEtag() {
        return this.etag;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbResourceInfo)) {
            return false;
        }
        TbResourceInfo other = (TbResourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        String this$resourceKey = this.getResourceKey();
        String other$resourceKey = other.getResourceKey();
        if (this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey)) {
            return false;
        }
        String this$searchText = this.getSearchText();
        String other$searchText = other.getSearchText();
        if (this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText)) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbResourceInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        String $resourceKey = this.getResourceKey();
        result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
        String $searchText = this.getSearchText();
        result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        return result;
    }
}

