/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.google.common.base.Splitter;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.RandomStringUtils;

public class StringUtils {
    private static final int DEFAULT_TOKEN_LENGTH = 8;
    public static final SecureRandom RANDOM = new SecureRandom();
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(String source) {
        return source == null || source.isEmpty();
    }

    public static boolean isBlank(String source) {
        return source == null || source.isEmpty() || source.trim().isEmpty();
    }

    public static boolean isNotEmpty(String source) {
        return source != null && !source.isEmpty();
    }

    public static boolean isNotBlank(String source) {
        return source != null && !source.isEmpty() && !source.trim().isEmpty();
    }

    public static String notBlankOrDefault(String src, String def) {
        return StringUtils.isNotBlank(src) ? src : def;
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String obfuscate(String input, int seenMargin, char obfuscationChar, int startIndexInclusive, int endIndexExclusive) {
        String part = input.substring(startIndexInclusive, endIndexExclusive);
        Object obfuscatedPart = part.length() <= seenMargin * 2 ? org.apache.commons.lang3.StringUtils.repeat((char)obfuscationChar, (int)part.length()) : part.substring(0, seenMargin) + org.apache.commons.lang3.StringUtils.repeat((char)obfuscationChar, (int)(part.length() - seenMargin * 2)) + part.substring(part.length() - seenMargin);
        return input.substring(0, startIndexInclusive) + (String)obfuscatedPart + input.substring(endIndexExclusive);
    }

    public static String emptyIfNull(String src) {
        return src != null ? src : EMPTY;
    }

    public static Iterable<String> split(String value, int maxPartSize) {
        return Splitter.fixedLength((int)maxPartSize).split((CharSequence)value);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String join(String[] keyArray, String lwm2mSeparatorPath) {
        return org.apache.commons.lang3.StringUtils.join((Object[])keyArray, (String)lwm2mSeparatorPath);
    }

    public static String trimToNull(String toString) {
        return org.apache.commons.lang3.StringUtils.trimToNull((String)toString);
    }

    public static boolean isNoneEmpty(String str) {
        return org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{str});
    }

    public static boolean endsWith(String str, String suffix) {
        return org.apache.commons.lang3.StringUtils.endsWith((CharSequence)str, (CharSequence)suffix);
    }

    public static boolean hasLength(String str) {
        return org.springframework.util.StringUtils.hasLength((String)str);
    }

    public static boolean isNoneBlank(String ... str) {
        return org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])str);
    }

    public static boolean hasText(String str) {
        return org.springframework.util.StringUtils.hasText((String)str);
    }

    public static String defaultString(String s, String defaultValue) {
        return org.apache.commons.lang3.StringUtils.defaultString((String)s, (String)defaultValue);
    }

    public static boolean isNumeric(String str) {
        return org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)str);
    }

    public static boolean equals(String str1, String str2) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)str1, (CharSequence)str2);
    }

    public static boolean equalsAny(String string, String ... otherStrings) {
        for (String otherString : otherStrings) {
            if (!StringUtils.equals(string, otherString)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String string, String ... otherStrings) {
        for (String otherString : otherStrings) {
            if (!StringUtils.equalsIgnoreCase(string, otherString)) continue;
            return true;
        }
        return false;
    }

    public static String substringAfterLast(String str, String sep) {
        return org.apache.commons.lang3.StringUtils.substringAfterLast((String)str, (String)sep);
    }

    public static String removeEnd(String str, String suffix) {
        return org.apache.commons.lang3.StringUtils.removeEnd((String)str, (String)suffix);
    }

    public static boolean containedByAny(String searchString, String ... strings) {
        if (searchString == null) {
            return false;
        }
        for (String string : strings) {
            if (string == null || !string.contains(searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        return org.apache.commons.lang3.StringUtils.contains((CharSequence)seq, (CharSequence)searchSeq);
    }

    public static boolean contains0x00(String s) {
        return s != null && s.contains("\u0000");
    }

    public static String randomNumeric(int length) {
        return RandomStringUtils.randomNumeric((int)length);
    }

    public static String random(int length) {
        return RandomStringUtils.random((int)length);
    }

    public static String random(int length, String chars) {
        return RandomStringUtils.random((int)length, (String)chars);
    }

    public static String randomAlphanumeric(int count) {
        return RandomStringUtils.randomAlphanumeric((int)count);
    }

    public static String randomAlphabetic(int count) {
        return RandomStringUtils.randomAlphabetic((int)count);
    }

    public static String generateSafeToken(int length) {
        byte[] bytes = new byte[length];
        RANDOM.nextBytes(bytes);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return encoder.encodeToString(bytes);
    }

    public static String generateSafeToken() {
        return StringUtils.generateSafeToken(8);
    }
}

