/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum EntityType {
    TENANT,
    CUSTOMER,
    USER,
    DASHBOARD,
    ASSET,
    DEVICE,
    ALARM,
    ENTITY_GROUP{

        @Override
        public String getNormalName() {
            return "Entity Group";
        }
    }
    ,
    CONVERTER,
    INTEGRATION,
    RULE_CHAIN,
    RULE_NODE,
    SCHEDULER_EVENT,
    BLOB_ENTITY,
    ENTITY_VIEW{

        @Override
        public String getNormalName() {
            return "Entity View";
        }
    }
    ,
    WIDGETS_BUNDLE,
    WIDGET_TYPE,
    ROLE,
    GROUP_PERMISSION,
    TENANT_PROFILE,
    DEVICE_PROFILE,
    ASSET_PROFILE,
    API_USAGE_STATE,
    TB_RESOURCE,
    OTA_PACKAGE,
    EDGE,
    RPC,
    QUEUE,
    NOTIFICATION_TARGET,
    NOTIFICATION_TEMPLATE,
    NOTIFICATION_REQUEST,
    NOTIFICATION,
    NOTIFICATION_RULE;

    public static final List<String> NORMAL_NAMES;
    private final String normalName = StringUtils.capitalize((String)StringUtils.removeStart((String)this.name(), (String)"TB_").toLowerCase().replaceAll("_", " "));

    public String getNormalName() {
        return this.normalName;
    }

    static {
        NORMAL_NAMES = EnumSet.allOf(EntityType.class).stream().map(EntityType::getNormalName).collect(Collectors.toUnmodifiableList());
    }
}

