/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.HasId;

@ApiModel
public class EntityInfo
implements HasId<EntityId>,
HasName {
    @ApiModelProperty(position=1, value="JSON object with the entity Id. ")
    private final EntityId id;
    @ApiModelProperty(position=2, value="Entity Name")
    private final String name;

    @JsonCreator
    public EntityInfo(@JsonProperty(value="id") EntityId id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = name;
    }

    public EntityInfo(UUID uuid, String entityType, String name) {
        this.id = EntityIdFactory.getByTypeAndUuid(entityType, uuid);
        this.name = name;
    }

    @Override
    public EntityId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityInfo)) {
            return false;
        }
        EntityInfo other = (EntityInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$id = this.getId();
        EntityId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "EntityInfo(id=" + this.getId() + ", name=" + this.getName() + ")";
    }
}

