/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.TenantId;

public class DeviceInfoFilter {
    private TenantId tenantId;
    private boolean includeCustomers;
    private CustomerId customerId;
    private DeviceProfileId deviceProfileId;
    private Boolean active;

    @ConstructorProperties(value={"tenantId", "includeCustomers", "customerId", "deviceProfileId", "active"})
    DeviceInfoFilter(TenantId tenantId, boolean includeCustomers, CustomerId customerId, DeviceProfileId deviceProfileId, Boolean active) {
        this.tenantId = tenantId;
        this.includeCustomers = includeCustomers;
        this.customerId = customerId;
        this.deviceProfileId = deviceProfileId;
        this.active = active;
    }

    public static DeviceInfoFilterBuilder builder() {
        return new DeviceInfoFilterBuilder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public boolean isIncludeCustomers() {
        return this.includeCustomers;
    }

    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public DeviceProfileId getDeviceProfileId() {
        return this.deviceProfileId;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setIncludeCustomers(boolean includeCustomers) {
        this.includeCustomers = includeCustomers;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setDeviceProfileId(DeviceProfileId deviceProfileId) {
        this.deviceProfileId = deviceProfileId;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfoFilter)) {
            return false;
        }
        DeviceInfoFilter other = (DeviceInfoFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeCustomers() != other.isIncludeCustomers()) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        DeviceProfileId this$deviceProfileId = this.getDeviceProfileId();
        DeviceProfileId other$deviceProfileId = other.getDeviceProfileId();
        return !(this$deviceProfileId == null ? other$deviceProfileId != null : !((Object)this$deviceProfileId).equals(other$deviceProfileId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfoFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeCustomers() ? 79 : 97);
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        DeviceProfileId $deviceProfileId = this.getDeviceProfileId();
        result = result * 59 + ($deviceProfileId == null ? 43 : ((Object)$deviceProfileId).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceInfoFilter(tenantId=" + this.getTenantId() + ", includeCustomers=" + this.isIncludeCustomers() + ", customerId=" + this.getCustomerId() + ", deviceProfileId=" + this.getDeviceProfileId() + ", active=" + this.getActive() + ")";
    }

    public static class DeviceInfoFilterBuilder {
        private TenantId tenantId;
        private boolean includeCustomers;
        private CustomerId customerId;
        private DeviceProfileId deviceProfileId;
        private Boolean active;

        DeviceInfoFilterBuilder() {
        }

        public DeviceInfoFilterBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public DeviceInfoFilterBuilder includeCustomers(boolean includeCustomers) {
            this.includeCustomers = includeCustomers;
            return this;
        }

        public DeviceInfoFilterBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public DeviceInfoFilterBuilder deviceProfileId(DeviceProfileId deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public DeviceInfoFilterBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public DeviceInfoFilter build() {
            return new DeviceInfoFilter(this.tenantId, this.includeCustomers, this.customerId, this.deviceProfileId, this.active);
        }

        public String toString() {
            return "DeviceInfoFilter.DeviceInfoFilterBuilder(tenantId=" + this.tenantId + ", includeCustomers=" + this.includeCustomers + ", customerId=" + this.customerId + ", deviceProfileId=" + this.deviceProfileId + ", active=" + this.active + ")";
        }
    }
}

