/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Streams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Dashboard
extends BaseData<DashboardId>
implements GroupEntity<DashboardId>,
HasName,
HasTenantId,
HasTitle,
ExportableEntity<DashboardId> {
    private static final long serialVersionUID = 872682138346187503L;
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="title")
    private String title;
    @Length(fieldName="image", max=1000000)
    private String image;
    @Valid
    private Set<ShortCustomerInfo> assignedCustomers;
    private boolean mobileHide;
    private Integer mobileOrder;
    private transient JsonNode configuration;
    private DashboardId externalId;

    public Dashboard() {
    }

    public Dashboard(DashboardId id) {
        super(id);
    }

    public Dashboard(DashboardInfo dashboardInfo) {
        super(dashboardInfo);
    }

    public Dashboard(Dashboard dashboard) {
        super(dashboard);
        this.tenantId = dashboard.getTenantId();
        this.customerId = dashboard.getCustomerId();
        this.title = dashboard.getTitle();
        this.image = dashboard.getImage();
        this.assignedCustomers = dashboard.getAssignedCustomers();
        this.mobileHide = dashboard.isMobileHide();
        this.mobileOrder = dashboard.getMobileOrder();
        this.configuration = dashboard.getConfiguration();
        this.externalId = dashboard.getExternalId();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the dashboard Id. Specify existing dashboard Id to update the dashboard. Referencing non-existing dashboard id will cause error. Omit this field to create new dashboard.")
    public DashboardId getId() {
        return (DashboardId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the dashboard creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with Tenant Id. Tenant Id of the dashboard can't be changed.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @ApiModelProperty(position=4, value="JSON object with Customer Id. ")
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Override
    @ApiModelProperty(position=5, value="JSON object with Customer or Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @ApiModelProperty(position=6, value="Title of the dashboard.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @ApiModelProperty(position=7, value="Thumbnail picture for rendering of the dashboards in a grid view on mobile devices.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @ApiModelProperty(position=8, value="List of assigned customers with their info.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Set<ShortCustomerInfo> getAssignedCustomers() {
        return this.assignedCustomers;
    }

    public void setAssignedCustomers(Set<ShortCustomerInfo> assignedCustomers) {
        this.assignedCustomers = assignedCustomers;
    }

    @ApiModelProperty(position=9, value="Hide dashboard from mobile devices. Useful if the dashboard is not designed for small screens.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public boolean isMobileHide() {
        return this.mobileHide;
    }

    public void setMobileHide(boolean mobileHide) {
        this.mobileHide = mobileHide;
    }

    @ApiModelProperty(position=10, value="Order on mobile devices. Useful to adjust sorting of the dashboards for mobile applications", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Integer getMobileOrder() {
        return this.mobileOrder;
    }

    public void setMobileOrder(Integer mobileOrder) {
        this.mobileOrder = mobileOrder;
    }

    @Override
    @ApiModelProperty(position=11, value="Same as title of the dashboard. Read-only field. Update the 'title' to change the 'name' of the dashboard.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @ApiModelProperty(position=12, value="JSON object with main configuration of the dashboard: layouts, widgets, aliases, etc. The JSON structure of the dashboard configuration is quite complex. The easiest way to learn it is to export existing dashboard to JSON.", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public boolean isAssignedToCustomer(CustomerId customerId) {
        return this.assignedCustomers != null && this.assignedCustomers.contains(new ShortCustomerInfo(customerId, null, false));
    }

    public ShortCustomerInfo getAssignedCustomerInfo(CustomerId customerId) {
        if (this.assignedCustomers != null) {
            for (ShortCustomerInfo customerInfo : this.assignedCustomers) {
                if (!customerInfo.getCustomerId().equals(customerId)) continue;
                return customerInfo;
            }
        }
        return null;
    }

    public boolean addAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            return false;
        }
        if (this.assignedCustomers == null) {
            this.assignedCustomers = new HashSet<ShortCustomerInfo>();
        }
        this.assignedCustomers.add(customerInfo);
        return true;
    }

    public boolean updateAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            this.assignedCustomers.remove(customerInfo);
            this.assignedCustomers.add(customerInfo);
            return true;
        }
        return false;
    }

    public boolean removeAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            this.assignedCustomers.remove(customerInfo);
            return true;
        }
        return false;
    }

    public boolean removeAssignedCustomerInfo(ShortCustomerInfo customerInfo) {
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            this.assignedCustomers.remove(customerInfo);
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.DASHBOARD;
    }

    @JsonIgnore
    public List<ObjectNode> getEntityAliasesConfig() {
        return this.getChildObjects("entityAliases");
    }

    @JsonIgnore
    public List<ObjectNode> getWidgetsConfig() {
        return this.getChildObjects("widgets");
    }

    @JsonIgnore
    private List<ObjectNode> getChildObjects(String propertyName) {
        return Optional.ofNullable(this.configuration).map(config -> config.get(propertyName)).filter(node -> !node.isEmpty() && (node.isObject() || node.isArray())).map(node -> Streams.stream((Iterator)node.elements()).filter(JsonNode::isObject).map(jsonNode -> (ObjectNode)jsonNode).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dashboard [tenantId=");
        builder.append(this.tenantId);
        builder.append(", customerId=");
        builder.append(this.customerId);
        builder.append(", title=");
        builder.append(this.title);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isMobileHide() != other.isMobileHide()) {
            return false;
        }
        Integer this$mobileOrder = this.getMobileOrder();
        Integer other$mobileOrder = other.getMobileOrder();
        if (this$mobileOrder == null ? other$mobileOrder != null : !((Object)this$mobileOrder).equals(other$mobileOrder)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Set<ShortCustomerInfo> this$assignedCustomers = this.getAssignedCustomers();
        Set<ShortCustomerInfo> other$assignedCustomers = other.getAssignedCustomers();
        if (this$assignedCustomers == null ? other$assignedCustomers != null : !((Object)this$assignedCustomers).equals(other$assignedCustomers)) {
            return false;
        }
        DashboardId this$externalId = this.getExternalId();
        DashboardId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dashboard;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMobileHide() ? 79 : 97);
        Integer $mobileOrder = this.getMobileOrder();
        result = result * 59 + ($mobileOrder == null ? 43 : ((Object)$mobileOrder).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Set<ShortCustomerInfo> $assignedCustomers = this.getAssignedCustomers();
        result = result * 59 + ($assignedCustomers == null ? 43 : ((Object)$assignedCustomers).hashCode());
        DashboardId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public DashboardId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(DashboardId externalId) {
        this.externalId = externalId;
    }
}

