/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.NoXss;
import org.thingsboard.server.common.data.widget.BaseWidgetType;

public class WidgetTypeInfo
extends BaseWidgetType {
    @ApiModelProperty(position=7, value="Base64 encoded widget thumbnail", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String image;
    @NoXss
    @ApiModelProperty(position=7, value="Description of the widget type", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String description;
    @NoXss
    @ApiModelProperty(position=8, value="Type of the widget (timeseries, latest, control, alarm or static)", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String widgetType;

    public WidgetTypeInfo() {
    }

    public WidgetTypeInfo(WidgetTypeId id) {
        super(id);
    }

    public WidgetTypeInfo(BaseWidgetType baseWidgetType) {
        super(baseWidgetType);
    }

    public WidgetTypeInfo(WidgetTypeInfo widgetTypeInfo) {
        super(widgetTypeInfo);
        this.image = widgetTypeInfo.getImage();
        this.description = widgetTypeInfo.getDescription();
        this.widgetType = widgetTypeInfo.getWidgetType();
    }

    public String getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetTypeInfo)) {
            return false;
        }
        WidgetTypeInfo other = (WidgetTypeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$widgetType = this.getWidgetType();
        String other$widgetType = other.getWidgetType();
        return !(this$widgetType == null ? other$widgetType != null : !this$widgetType.equals(other$widgetType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WidgetTypeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $widgetType = this.getWidgetType();
        result = result * 59 + ($widgetType == null ? 43 : $widgetType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WidgetTypeInfo(image=" + this.getImage() + ", description=" + this.getDescription() + ", widgetType=" + this.getWidgetType() + ")";
    }
}

