/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security.model.mfa;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformTwoFaSettings {
    @Valid
    @NotNull
    private List<TwoFaProviderConfig> providers;
    @NotNull
    @Min(value=5L)
    private @NotNull @Min(value=5L) Integer minVerificationCodeSendPeriod;
    @Pattern(regexp="[1-9]\\d*:[1-9]\\d*", message="is invalid")
    private @Pattern(regexp="[1-9]\\d*:[1-9]\\d*", message="is invalid") String verificationCodeCheckRateLimit;
    @Min(value=0L, message="must be positive")
    private @Min(value=0L, message="must be positive") Integer maxVerificationFailuresBeforeUserLockout;
    @NotNull
    @Min(value=60L)
    private @NotNull @Min(value=60L) Integer totalAllowedTimeForVerification;

    public Optional<TwoFaProviderConfig> getProviderConfig(TwoFaProviderType providerType) {
        return Optional.ofNullable(this.providers).flatMap(providersConfigs -> providersConfigs.stream().filter(providerConfig -> providerConfig.getProviderType() == providerType).findFirst());
    }

    public List<TwoFaProviderConfig> getProviders() {
        return this.providers;
    }

    public Integer getMinVerificationCodeSendPeriod() {
        return this.minVerificationCodeSendPeriod;
    }

    public String getVerificationCodeCheckRateLimit() {
        return this.verificationCodeCheckRateLimit;
    }

    public Integer getMaxVerificationFailuresBeforeUserLockout() {
        return this.maxVerificationFailuresBeforeUserLockout;
    }

    public Integer getTotalAllowedTimeForVerification() {
        return this.totalAllowedTimeForVerification;
    }

    public void setProviders(List<TwoFaProviderConfig> providers) {
        this.providers = providers;
    }

    public void setMinVerificationCodeSendPeriod(Integer minVerificationCodeSendPeriod) {
        this.minVerificationCodeSendPeriod = minVerificationCodeSendPeriod;
    }

    public void setVerificationCodeCheckRateLimit(String verificationCodeCheckRateLimit) {
        this.verificationCodeCheckRateLimit = verificationCodeCheckRateLimit;
    }

    public void setMaxVerificationFailuresBeforeUserLockout(Integer maxVerificationFailuresBeforeUserLockout) {
        this.maxVerificationFailuresBeforeUserLockout = maxVerificationFailuresBeforeUserLockout;
    }

    public void setTotalAllowedTimeForVerification(Integer totalAllowedTimeForVerification) {
        this.totalAllowedTimeForVerification = totalAllowedTimeForVerification;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformTwoFaSettings)) {
            return false;
        }
        PlatformTwoFaSettings other = (PlatformTwoFaSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minVerificationCodeSendPeriod = this.getMinVerificationCodeSendPeriod();
        Integer other$minVerificationCodeSendPeriod = other.getMinVerificationCodeSendPeriod();
        if (this$minVerificationCodeSendPeriod == null ? other$minVerificationCodeSendPeriod != null : !((Object)this$minVerificationCodeSendPeriod).equals(other$minVerificationCodeSendPeriod)) {
            return false;
        }
        Integer this$maxVerificationFailuresBeforeUserLockout = this.getMaxVerificationFailuresBeforeUserLockout();
        Integer other$maxVerificationFailuresBeforeUserLockout = other.getMaxVerificationFailuresBeforeUserLockout();
        if (this$maxVerificationFailuresBeforeUserLockout == null ? other$maxVerificationFailuresBeforeUserLockout != null : !((Object)this$maxVerificationFailuresBeforeUserLockout).equals(other$maxVerificationFailuresBeforeUserLockout)) {
            return false;
        }
        Integer this$totalAllowedTimeForVerification = this.getTotalAllowedTimeForVerification();
        Integer other$totalAllowedTimeForVerification = other.getTotalAllowedTimeForVerification();
        if (this$totalAllowedTimeForVerification == null ? other$totalAllowedTimeForVerification != null : !((Object)this$totalAllowedTimeForVerification).equals(other$totalAllowedTimeForVerification)) {
            return false;
        }
        List<TwoFaProviderConfig> this$providers = this.getProviders();
        List<TwoFaProviderConfig> other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers)) {
            return false;
        }
        String this$verificationCodeCheckRateLimit = this.getVerificationCodeCheckRateLimit();
        String other$verificationCodeCheckRateLimit = other.getVerificationCodeCheckRateLimit();
        return !(this$verificationCodeCheckRateLimit == null ? other$verificationCodeCheckRateLimit != null : !this$verificationCodeCheckRateLimit.equals(other$verificationCodeCheckRateLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformTwoFaSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minVerificationCodeSendPeriod = this.getMinVerificationCodeSendPeriod();
        result = result * 59 + ($minVerificationCodeSendPeriod == null ? 43 : ((Object)$minVerificationCodeSendPeriod).hashCode());
        Integer $maxVerificationFailuresBeforeUserLockout = this.getMaxVerificationFailuresBeforeUserLockout();
        result = result * 59 + ($maxVerificationFailuresBeforeUserLockout == null ? 43 : ((Object)$maxVerificationFailuresBeforeUserLockout).hashCode());
        Integer $totalAllowedTimeForVerification = this.getTotalAllowedTimeForVerification();
        result = result * 59 + ($totalAllowedTimeForVerification == null ? 43 : ((Object)$totalAllowedTimeForVerification).hashCode());
        List<TwoFaProviderConfig> $providers = this.getProviders();
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        String $verificationCodeCheckRateLimit = this.getVerificationCodeCheckRateLimit();
        result = result * 59 + ($verificationCodeCheckRateLimit == null ? 43 : $verificationCodeCheckRateLimit.hashCode());
        return result;
    }

    public String toString() {
        return "PlatformTwoFaSettings(providers=" + this.getProviders() + ", minVerificationCodeSendPeriod=" + this.getMinVerificationCodeSendPeriod() + ", verificationCodeCheckRateLimit=" + this.getVerificationCodeCheckRateLimit() + ", maxVerificationFailuresBeforeUserLockout=" + this.getMaxVerificationFailuresBeforeUserLockout() + ", totalAllowedTimeForVerification=" + this.getTotalAllowedTimeForVerification() + ")";
    }
}

