/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.relation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.validation.Length;

@ApiModel
public class EntityRelation
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(EntityRelation.class);
    private static final long serialVersionUID = 2807343040519543363L;
    public static final String EDGE_TYPE = "ManagedByEdge";
    public static final String CONTAINS_TYPE = "Contains";
    public static final String MANAGES_TYPE = "Manages";
    private EntityId from;
    private EntityId to;
    @Length(fieldName="type")
    private String type;
    private RelationTypeGroup typeGroup;
    private transient JsonNode additionalInfo;
    @JsonIgnore
    private byte[] additionalInfoBytes;

    public EntityRelation() {
    }

    public EntityRelation(EntityId from, EntityId to, String type) {
        this(from, to, type, RelationTypeGroup.COMMON);
    }

    public EntityRelation(EntityId from, EntityId to, String type, RelationTypeGroup typeGroup) {
        this(from, to, type, typeGroup, null);
    }

    public EntityRelation(EntityId from, EntityId to, String type, RelationTypeGroup typeGroup, JsonNode additionalInfo) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.typeGroup = typeGroup;
        this.additionalInfo = additionalInfo;
    }

    public EntityRelation(EntityRelation entityRelation) {
        this.from = entityRelation.getFrom();
        this.to = entityRelation.getTo();
        this.type = entityRelation.getType();
        this.typeGroup = entityRelation.getTypeGroup();
        this.additionalInfo = entityRelation.getAdditionalInfo();
    }

    @ApiModelProperty(position=1, value="JSON object with [from] Entity Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getFrom() {
        return this.from;
    }

    public void setFrom(EntityId from) {
        this.from = from;
    }

    @ApiModelProperty(position=2, value="JSON object with [to] Entity Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getTo() {
        return this.to;
    }

    public void setTo(EntityId to) {
        this.to = to;
    }

    @ApiModelProperty(position=3, value="String value of relation type.", example="Contains")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(position=4, value="Represents the type group of the relation.", example="COMMON")
    public RelationTypeGroup getTypeGroup() {
        return this.typeGroup;
    }

    public void setTypeGroup(RelationTypeGroup typeGroup) {
        this.typeGroup = typeGroup;
    }

    @ApiModelProperty(position=5, value="Additional parameters of the relation", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.additionalInfo, () -> this.additionalInfoBytes);
    }

    public void setAdditionalInfo(JsonNode addInfo) {
        SearchTextBasedWithAdditionalInfo.setJson(addInfo, json -> {
            this.additionalInfo = json;
        }, bytes -> {
            this.additionalInfoBytes = bytes;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityRelation that = (EntityRelation)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.typeGroup == that.typeGroup;
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.typeGroup != null ? this.typeGroup.hashCode() : 0);
        return result;
    }
}

