/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.oauth2.SchemeType;

@ApiModel
public class OAuth2DomainInfo {
    @ApiModelProperty(value="Domain scheme. Mixed scheme means than both HTTP and HTTPS are going to be used", required=true)
    private SchemeType scheme;
    @ApiModelProperty(value="Domain name. Cannot be empty", required=true)
    private String name;

    public static OAuth2DomainInfoBuilder builder() {
        return new OAuth2DomainInfoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2DomainInfo)) {
            return false;
        }
        OAuth2DomainInfo other = (OAuth2DomainInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemeType this$scheme = this.getScheme();
        SchemeType other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !((Object)((Object)this$scheme)).equals((Object)other$scheme)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2DomainInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemeType $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : ((Object)((Object)$scheme)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public SchemeType getScheme() {
        return this.scheme;
    }

    public String getName() {
        return this.name;
    }

    public void setScheme(SchemeType scheme) {
        this.scheme = scheme;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "OAuth2DomainInfo(scheme=" + this.getScheme() + ", name=" + this.getName() + ")";
    }

    public OAuth2DomainInfo() {
    }

    @ConstructorProperties(value={"scheme", "name"})
    public OAuth2DomainInfo(SchemeType scheme, String name) {
        this.scheme = scheme;
        this.name = name;
    }

    public static class OAuth2DomainInfoBuilder {
        private SchemeType scheme;
        private String name;

        OAuth2DomainInfoBuilder() {
        }

        public OAuth2DomainInfoBuilder scheme(SchemeType scheme) {
            this.scheme = scheme;
            return this;
        }

        public OAuth2DomainInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OAuth2DomainInfo build() {
            return new OAuth2DomainInfo(this.scheme, this.name);
        }

        public String toString() {
            return "OAuth2DomainInfo.OAuth2DomainInfoBuilder(scheme=" + this.scheme + ", name=" + this.name + ")";
        }
    }
}

