/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Set;
import javax.validation.constraints.Max;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTriggerType;

public class EntitiesLimitNotificationRuleTriggerConfig
implements NotificationRuleTriggerConfig {
    private Set<EntityType> entityTypes;
    @Max(value=1L)
    private @Max(value=1L) float threshold;

    @Override
    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ENTITIES_LIMIT;
    }

    public static EntitiesLimitNotificationRuleTriggerConfigBuilder builder() {
        return new EntitiesLimitNotificationRuleTriggerConfigBuilder();
    }

    public Set<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setEntityTypes(Set<EntityType> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesLimitNotificationRuleTriggerConfig)) {
            return false;
        }
        EntitiesLimitNotificationRuleTriggerConfig other = (EntitiesLimitNotificationRuleTriggerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getThreshold(), other.getThreshold()) != 0) {
            return false;
        }
        Set<EntityType> this$entityTypes = this.getEntityTypes();
        Set<EntityType> other$entityTypes = other.getEntityTypes();
        return !(this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntitiesLimitNotificationRuleTriggerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getThreshold());
        Set<EntityType> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        return result;
    }

    public String toString() {
        return "EntitiesLimitNotificationRuleTriggerConfig(entityTypes=" + this.getEntityTypes() + ", threshold=" + this.getThreshold() + ")";
    }

    @ConstructorProperties(value={"entityTypes", "threshold"})
    public EntitiesLimitNotificationRuleTriggerConfig(Set<EntityType> entityTypes, float threshold) {
        this.entityTypes = entityTypes;
        this.threshold = threshold;
    }

    public EntitiesLimitNotificationRuleTriggerConfig() {
    }

    public static class EntitiesLimitNotificationRuleTriggerConfigBuilder {
        private Set<EntityType> entityTypes;
        private float threshold;

        EntitiesLimitNotificationRuleTriggerConfigBuilder() {
        }

        public EntitiesLimitNotificationRuleTriggerConfigBuilder entityTypes(Set<EntityType> entityTypes) {
            this.entityTypes = entityTypes;
            return this;
        }

        public EntitiesLimitNotificationRuleTriggerConfigBuilder threshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        public EntitiesLimitNotificationRuleTriggerConfig build() {
            return new EntitiesLimitNotificationRuleTriggerConfig(this.entityTypes, this.threshold);
        }

        public String toString() {
            return "EntitiesLimitNotificationRuleTriggerConfig.EntitiesLimitNotificationRuleTriggerConfigBuilder(entityTypes=" + this.entityTypes + ", threshold=" + this.threshold + ")";
        }
    }
}

