/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;

public class BaseReadTsKvQuery
extends BaseTsKvQuery
implements ReadTsKvQuery {
    private final long interval;
    private final int limit;
    private final Aggregation aggregation;
    private final String order;

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation) {
        this(key, startTs, endTs, interval, limit, aggregation, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation, String order) {
        super(key, startTs, endTs);
        this.interval = interval;
        this.limit = limit;
        this.aggregation = aggregation;
        this.order = order;
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs) {
        this(key, startTs, endTs, endTs - startTs, 1, Aggregation.AVG, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, int limit, String order) {
        this(key, startTs, endTs, endTs - startTs, limit, Aggregation.NONE, order);
    }

    public BaseReadTsKvQuery(ReadTsKvQuery query, long startTs, long endTs) {
        super(query.getId(), query.getKey(), startTs, endTs);
        this.interval = query.getInterval();
        this.limit = query.getLimit();
        this.aggregation = query.getAggregation();
        this.order = query.getOrder();
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Aggregation getAggregation() {
        return this.aggregation;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public String toString() {
        return "BaseReadTsKvQuery(interval=" + this.getInterval() + ", limit=" + this.getLimit() + ", aggregation=" + this.getAggregation() + ", order=" + this.getOrder() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseReadTsKvQuery)) {
            return false;
        }
        BaseReadTsKvQuery other = (BaseReadTsKvQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        Aggregation this$aggregation = this.getAggregation();
        Aggregation other$aggregation = other.getAggregation();
        if (this$aggregation == null ? other$aggregation != null : !((Object)((Object)this$aggregation)).equals((Object)other$aggregation)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseReadTsKvQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        result = result * 59 + this.getLimit();
        Aggregation $aggregation = this.getAggregation();
        result = result * 59 + ($aggregation == null ? 43 : ((Object)((Object)$aggregation)).hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }
}

