/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;

@ApiModel
public class ErrorEventFilter
implements EventFilter {
    @ApiModelProperty(position=1, value="String value representing the server name, identifier or ip address where the platform is running", example="ip-172-31-24-152")
    protected String server;
    @ApiModelProperty(position=2, value="String value representing the method name when the error happened", example="onClusterEventMsg")
    protected String method;
    @ApiModelProperty(position=3, value="The case insensitive 'contains' filter based on error message", example="not present in the DB")
    protected String errorStr;

    @Override
    public EventType getEventType() {
        return EventType.ERROR;
    }

    @Override
    public boolean isNotEmpty() {
        return !StringUtils.isEmpty(this.server) || !StringUtils.isEmpty(this.method) || !StringUtils.isEmpty(this.errorStr);
    }

    public String getServer() {
        return this.server;
    }

    public String getMethod() {
        return this.method;
    }

    public String getErrorStr() {
        return this.errorStr;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorEventFilter)) {
            return false;
        }
        ErrorEventFilter other = (ErrorEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$errorStr = this.getErrorStr();
        String other$errorStr = other.getErrorStr();
        return !(this$errorStr == null ? other$errorStr != null : !this$errorStr.equals(other$errorStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorEventFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $errorStr = this.getErrorStr();
        result = result * 59 + ($errorStr == null ? 43 : $errorStr.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorEventFilter(server=" + this.getServer() + ", method=" + this.getMethod() + ", errorStr=" + this.getErrorStr() + ")";
    }
}

