/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.squareup.wire.schema.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DynamicProtoUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TransportPayloadType;
import org.thingsboard.server.common.data.device.profile.TransportPayloadTypeConfiguration;

public class ProtoTransportPayloadConfiguration
implements TransportPayloadTypeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ProtoTransportPayloadConfiguration.class);
    public static final Location LOCATION = new Location("", "", -1, -1);
    public static final String ATTRIBUTES_PROTO_SCHEMA = "attributes proto schema";
    public static final String TELEMETRY_PROTO_SCHEMA = "telemetry proto schema";
    public static final String RPC_RESPONSE_PROTO_SCHEMA = "rpc response proto schema";
    public static final String RPC_REQUEST_PROTO_SCHEMA = "rpc request proto schema";
    private static final String PROTO_3_SYNTAX = "proto3";
    private String deviceTelemetryProtoSchema;
    private String deviceAttributesProtoSchema;
    private String deviceRpcRequestProtoSchema;
    private String deviceRpcResponseProtoSchema;
    private boolean enableCompatibilityWithJsonPayloadFormat;
    private boolean useJsonPayloadFormatForDefaultDownlinkTopics;

    @Override
    public TransportPayloadType getTransportPayloadType() {
        return TransportPayloadType.PROTOBUF;
    }

    public Descriptors.Descriptor getTelemetryDynamicMessageDescriptor(String deviceTelemetryProtoSchema) {
        return DynamicProtoUtils.getDescriptor(deviceTelemetryProtoSchema, TELEMETRY_PROTO_SCHEMA);
    }

    public Descriptors.Descriptor getAttributesDynamicMessageDescriptor(String deviceAttributesProtoSchema) {
        return DynamicProtoUtils.getDescriptor(deviceAttributesProtoSchema, ATTRIBUTES_PROTO_SCHEMA);
    }

    public Descriptors.Descriptor getRpcResponseDynamicMessageDescriptor(String deviceRpcResponseProtoSchema) {
        return DynamicProtoUtils.getDescriptor(deviceRpcResponseProtoSchema, RPC_RESPONSE_PROTO_SCHEMA);
    }

    public DynamicMessage.Builder getRpcRequestDynamicMessageBuilder(String deviceRpcRequestProtoSchema) {
        return DynamicProtoUtils.getDynamicMessageBuilder(deviceRpcRequestProtoSchema, RPC_REQUEST_PROTO_SCHEMA);
    }

    public String getDeviceRpcResponseProtoSchema() {
        if (StringUtils.isNotEmpty(this.deviceRpcResponseProtoSchema)) {
            return this.deviceRpcResponseProtoSchema;
        }
        return "syntax =\"proto3\";\npackage rpc;\n\nmessage RpcResponseMsg {\n  optional string payload = 1;\n}";
    }

    public String getDeviceRpcRequestProtoSchema() {
        if (StringUtils.isNotEmpty(this.deviceRpcRequestProtoSchema)) {
            return this.deviceRpcRequestProtoSchema;
        }
        return "syntax =\"proto3\";\npackage rpc;\n\nmessage RpcRequestMsg {\n  optional string method = 1;\n  optional int32 requestId = 2;\n  optional string params = 3;\n}";
    }

    public String getDeviceTelemetryProtoSchema() {
        return this.deviceTelemetryProtoSchema;
    }

    public String getDeviceAttributesProtoSchema() {
        return this.deviceAttributesProtoSchema;
    }

    public boolean isEnableCompatibilityWithJsonPayloadFormat() {
        return this.enableCompatibilityWithJsonPayloadFormat;
    }

    public boolean isUseJsonPayloadFormatForDefaultDownlinkTopics() {
        return this.useJsonPayloadFormatForDefaultDownlinkTopics;
    }

    public void setDeviceTelemetryProtoSchema(String deviceTelemetryProtoSchema) {
        this.deviceTelemetryProtoSchema = deviceTelemetryProtoSchema;
    }

    public void setDeviceAttributesProtoSchema(String deviceAttributesProtoSchema) {
        this.deviceAttributesProtoSchema = deviceAttributesProtoSchema;
    }

    public void setDeviceRpcRequestProtoSchema(String deviceRpcRequestProtoSchema) {
        this.deviceRpcRequestProtoSchema = deviceRpcRequestProtoSchema;
    }

    public void setDeviceRpcResponseProtoSchema(String deviceRpcResponseProtoSchema) {
        this.deviceRpcResponseProtoSchema = deviceRpcResponseProtoSchema;
    }

    public void setEnableCompatibilityWithJsonPayloadFormat(boolean enableCompatibilityWithJsonPayloadFormat) {
        this.enableCompatibilityWithJsonPayloadFormat = enableCompatibilityWithJsonPayloadFormat;
    }

    public void setUseJsonPayloadFormatForDefaultDownlinkTopics(boolean useJsonPayloadFormatForDefaultDownlinkTopics) {
        this.useJsonPayloadFormatForDefaultDownlinkTopics = useJsonPayloadFormatForDefaultDownlinkTopics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtoTransportPayloadConfiguration)) {
            return false;
        }
        ProtoTransportPayloadConfiguration other = (ProtoTransportPayloadConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableCompatibilityWithJsonPayloadFormat() != other.isEnableCompatibilityWithJsonPayloadFormat()) {
            return false;
        }
        if (this.isUseJsonPayloadFormatForDefaultDownlinkTopics() != other.isUseJsonPayloadFormatForDefaultDownlinkTopics()) {
            return false;
        }
        String this$deviceTelemetryProtoSchema = this.getDeviceTelemetryProtoSchema();
        String other$deviceTelemetryProtoSchema = other.getDeviceTelemetryProtoSchema();
        if (this$deviceTelemetryProtoSchema == null ? other$deviceTelemetryProtoSchema != null : !this$deviceTelemetryProtoSchema.equals(other$deviceTelemetryProtoSchema)) {
            return false;
        }
        String this$deviceAttributesProtoSchema = this.getDeviceAttributesProtoSchema();
        String other$deviceAttributesProtoSchema = other.getDeviceAttributesProtoSchema();
        if (this$deviceAttributesProtoSchema == null ? other$deviceAttributesProtoSchema != null : !this$deviceAttributesProtoSchema.equals(other$deviceAttributesProtoSchema)) {
            return false;
        }
        String this$deviceRpcRequestProtoSchema = this.getDeviceRpcRequestProtoSchema();
        String other$deviceRpcRequestProtoSchema = other.getDeviceRpcRequestProtoSchema();
        if (this$deviceRpcRequestProtoSchema == null ? other$deviceRpcRequestProtoSchema != null : !this$deviceRpcRequestProtoSchema.equals(other$deviceRpcRequestProtoSchema)) {
            return false;
        }
        String this$deviceRpcResponseProtoSchema = this.getDeviceRpcResponseProtoSchema();
        String other$deviceRpcResponseProtoSchema = other.getDeviceRpcResponseProtoSchema();
        return !(this$deviceRpcResponseProtoSchema == null ? other$deviceRpcResponseProtoSchema != null : !this$deviceRpcResponseProtoSchema.equals(other$deviceRpcResponseProtoSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtoTransportPayloadConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableCompatibilityWithJsonPayloadFormat() ? 79 : 97);
        result = result * 59 + (this.isUseJsonPayloadFormatForDefaultDownlinkTopics() ? 79 : 97);
        String $deviceTelemetryProtoSchema = this.getDeviceTelemetryProtoSchema();
        result = result * 59 + ($deviceTelemetryProtoSchema == null ? 43 : $deviceTelemetryProtoSchema.hashCode());
        String $deviceAttributesProtoSchema = this.getDeviceAttributesProtoSchema();
        result = result * 59 + ($deviceAttributesProtoSchema == null ? 43 : $deviceAttributesProtoSchema.hashCode());
        String $deviceRpcRequestProtoSchema = this.getDeviceRpcRequestProtoSchema();
        result = result * 59 + ($deviceRpcRequestProtoSchema == null ? 43 : $deviceRpcRequestProtoSchema.hashCode());
        String $deviceRpcResponseProtoSchema = this.getDeviceRpcResponseProtoSchema();
        result = result * 59 + ($deviceRpcResponseProtoSchema == null ? 43 : $deviceRpcResponseProtoSchema.hashCode());
        return result;
    }

    public String toString() {
        return "ProtoTransportPayloadConfiguration(deviceTelemetryProtoSchema=" + this.getDeviceTelemetryProtoSchema() + ", deviceAttributesProtoSchema=" + this.getDeviceAttributesProtoSchema() + ", deviceRpcRequestProtoSchema=" + this.getDeviceRpcRequestProtoSchema() + ", deviceRpcResponseProtoSchema=" + this.getDeviceRpcResponseProtoSchema() + ", enableCompatibilityWithJsonPayloadFormat=" + this.isEnableCompatibilityWithJsonPayloadFormat() + ", useJsonPayloadFormatForDefaultDownlinkTopics=" + this.isUseJsonPayloadFormatForDefaultDownlinkTopics() + ")";
    }
}

