/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmModificationRequest;
import org.thingsboard.server.common.data.alarm.AlarmPropagationInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.NoXss;

public class AlarmUpdateRequest
implements AlarmModificationRequest {
    @NotNull
    @ApiModelProperty(position=1, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NotNull
    @ApiModelProperty(position=2, value="JSON object with the alarm Id. Specify this field to update the alarm. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.")
    private AlarmId alarmId;
    @NotNull
    @ApiModelProperty(position=3, required=true, value="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @ApiModelProperty(position=4, value="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @ApiModelProperty(position=5, value="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @NoXss
    @ApiModelProperty(position=6, value="JSON object with alarm details")
    private JsonNode details;
    @Valid
    @ApiModelProperty(position=7, value="JSON object with propagation details")
    private AlarmPropagationInfo propagation;
    private UserId userId;

    public static AlarmUpdateRequest fromAlarm(Alarm a) {
        return AlarmUpdateRequest.fromAlarm(a, null);
    }

    public static AlarmUpdateRequest fromAlarm(Alarm a, UserId userId) {
        return AlarmUpdateRequest.builder().tenantId(a.getTenantId()).alarmId(a.getId()).severity(a.getSeverity()).startTs(a.getStartTs()).endTs(a.getEndTs()).details(a.getDetails()).propagation(AlarmPropagationInfo.builder().propagate(a.isPropagate()).propagateToOwner(a.isPropagateToOwner()).propagateToTenant(a.isPropagateToTenant()).propagateRelationTypes(a.getPropagateRelationTypes()).build()).userId(userId).build();
    }

    @ConstructorProperties(value={"tenantId", "alarmId", "severity", "startTs", "endTs", "details", "propagation", "userId"})
    AlarmUpdateRequest(TenantId tenantId, AlarmId alarmId, AlarmSeverity severity, long startTs, long endTs, JsonNode details, AlarmPropagationInfo propagation, UserId userId) {
        this.tenantId = tenantId;
        this.alarmId = alarmId;
        this.severity = severity;
        this.startTs = startTs;
        this.endTs = endTs;
        this.details = details;
        this.propagation = propagation;
        this.userId = userId;
    }

    public static AlarmUpdateRequestBuilder builder() {
        return new AlarmUpdateRequestBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public AlarmId getAlarmId() {
        return this.alarmId;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public long getStartTs() {
        return this.startTs;
    }

    @Override
    public long getEndTs() {
        return this.endTs;
    }

    public JsonNode getDetails() {
        return this.details;
    }

    public AlarmPropagationInfo getPropagation() {
        return this.propagation;
    }

    @Override
    public UserId getUserId() {
        return this.userId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setAlarmId(AlarmId alarmId) {
        this.alarmId = alarmId;
    }

    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    @Override
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Override
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setDetails(JsonNode details) {
        this.details = details;
    }

    public void setPropagation(AlarmPropagationInfo propagation) {
        this.propagation = propagation;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmUpdateRequest)) {
            return false;
        }
        AlarmUpdateRequest other = (AlarmUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        AlarmId this$alarmId = this.getAlarmId();
        AlarmId other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        JsonNode this$details = this.getDetails();
        JsonNode other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        AlarmPropagationInfo this$propagation = this.getPropagation();
        AlarmPropagationInfo other$propagation = other.getPropagation();
        if (this$propagation == null ? other$propagation != null : !((Object)this$propagation).equals(other$propagation)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        AlarmId $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        JsonNode $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        AlarmPropagationInfo $propagation = this.getPropagation();
        result = result * 59 + ($propagation == null ? 43 : ((Object)$propagation).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmUpdateRequest(tenantId=" + this.getTenantId() + ", alarmId=" + this.getAlarmId() + ", severity=" + this.getSeverity() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", details=" + this.getDetails() + ", propagation=" + this.getPropagation() + ", userId=" + this.getUserId() + ")";
    }

    public static class AlarmUpdateRequestBuilder {
        private TenantId tenantId;
        private AlarmId alarmId;
        private AlarmSeverity severity;
        private long startTs;
        private long endTs;
        private JsonNode details;
        private AlarmPropagationInfo propagation;
        private UserId userId;

        AlarmUpdateRequestBuilder() {
        }

        public AlarmUpdateRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AlarmUpdateRequestBuilder alarmId(AlarmId alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public AlarmUpdateRequestBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        public AlarmUpdateRequestBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        public AlarmUpdateRequestBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        public AlarmUpdateRequestBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        public AlarmUpdateRequestBuilder propagation(AlarmPropagationInfo propagation) {
            this.propagation = propagation;
            return this;
        }

        public AlarmUpdateRequestBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        public AlarmUpdateRequest build() {
            return new AlarmUpdateRequest(this.tenantId, this.alarmId, this.severity, this.startTs, this.endTs, this.details, this.propagation, this.userId);
        }

        public String toString() {
            return "AlarmUpdateRequest.AlarmUpdateRequestBuilder(tenantId=" + this.tenantId + ", alarmId=" + this.alarmId + ", severity=" + this.severity + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", details=" + this.details + ", propagation=" + this.propagation + ", userId=" + this.userId + ")";
        }
    }
}

