/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmModificationRequest;
import org.thingsboard.server.common.data.alarm.AlarmPropagationInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class AlarmCreateOrUpdateActiveRequest
implements AlarmModificationRequest {
    @NotNull
    @ApiModelProperty(position=1, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=2, value="JSON object with Customer Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NotNull
    @ApiModelProperty(position=3, required=true, value="representing type of the Alarm", example="High Temperature Alarm")
    @Length(fieldName="type")
    private String type;
    @NotNull
    @ApiModelProperty(position=4, required=true, value="JSON object with alarm originator id")
    private EntityId originator;
    @NotNull
    @ApiModelProperty(position=5, required=true, value="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @ApiModelProperty(position=6, value="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @ApiModelProperty(position=7, value="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @NoXss
    @ApiModelProperty(position=8, value="JSON object with alarm details")
    private JsonNode details;
    @Valid
    @ApiModelProperty(position=9, value="JSON object with propagation details")
    private AlarmPropagationInfo propagation;
    private UserId userId;
    private AlarmId edgeAlarmId;

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a) {
        return AlarmCreateOrUpdateActiveRequest.fromAlarm(a, null);
    }

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a, UserId userId) {
        return AlarmCreateOrUpdateActiveRequest.fromAlarm(a, userId, null);
    }

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a, UserId userId, AlarmId edgeAlarmId) {
        return AlarmCreateOrUpdateActiveRequest.builder().tenantId(a.getTenantId()).customerId(a.getCustomerId()).type(a.getType()).originator(a.getOriginator()).severity(a.getSeverity()).startTs(a.getStartTs()).endTs(a.getEndTs()).details(a.getDetails()).propagation(AlarmPropagationInfo.builder().propagate(a.isPropagate()).propagateToOwner(a.isPropagateToOwner()).propagateToTenant(a.isPropagateToTenant()).propagateRelationTypes(a.getPropagateRelationTypes()).build()).userId(userId).edgeAlarmId(edgeAlarmId).build();
    }

    @ConstructorProperties(value={"tenantId", "customerId", "type", "originator", "severity", "startTs", "endTs", "details", "propagation", "userId", "edgeAlarmId"})
    AlarmCreateOrUpdateActiveRequest(TenantId tenantId, CustomerId customerId, String type, EntityId originator, AlarmSeverity severity, long startTs, long endTs, JsonNode details, AlarmPropagationInfo propagation, UserId userId, AlarmId edgeAlarmId) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.type = type;
        this.originator = originator;
        this.severity = severity;
        this.startTs = startTs;
        this.endTs = endTs;
        this.details = details;
        this.propagation = propagation;
        this.userId = userId;
        this.edgeAlarmId = edgeAlarmId;
    }

    public static AlarmCreateOrUpdateActiveRequestBuilder builder() {
        return new AlarmCreateOrUpdateActiveRequestBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public String getType() {
        return this.type;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public long getStartTs() {
        return this.startTs;
    }

    @Override
    public long getEndTs() {
        return this.endTs;
    }

    public JsonNode getDetails() {
        return this.details;
    }

    public AlarmPropagationInfo getPropagation() {
        return this.propagation;
    }

    @Override
    public UserId getUserId() {
        return this.userId;
    }

    public AlarmId getEdgeAlarmId() {
        return this.edgeAlarmId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOriginator(EntityId originator) {
        this.originator = originator;
    }

    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    @Override
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Override
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setDetails(JsonNode details) {
        this.details = details;
    }

    public void setPropagation(AlarmPropagationInfo propagation) {
        this.propagation = propagation;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public void setEdgeAlarmId(AlarmId edgeAlarmId) {
        this.edgeAlarmId = edgeAlarmId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmCreateOrUpdateActiveRequest)) {
            return false;
        }
        AlarmCreateOrUpdateActiveRequest other = (AlarmCreateOrUpdateActiveRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        JsonNode this$details = this.getDetails();
        JsonNode other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        AlarmPropagationInfo this$propagation = this.getPropagation();
        AlarmPropagationInfo other$propagation = other.getPropagation();
        if (this$propagation == null ? other$propagation != null : !((Object)this$propagation).equals(other$propagation)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        AlarmId this$edgeAlarmId = this.getEdgeAlarmId();
        AlarmId other$edgeAlarmId = other.getEdgeAlarmId();
        return !(this$edgeAlarmId == null ? other$edgeAlarmId != null : !((Object)this$edgeAlarmId).equals(other$edgeAlarmId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmCreateOrUpdateActiveRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        JsonNode $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        AlarmPropagationInfo $propagation = this.getPropagation();
        result = result * 59 + ($propagation == null ? 43 : ((Object)$propagation).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        AlarmId $edgeAlarmId = this.getEdgeAlarmId();
        result = result * 59 + ($edgeAlarmId == null ? 43 : ((Object)$edgeAlarmId).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmCreateOrUpdateActiveRequest(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", type=" + this.getType() + ", originator=" + this.getOriginator() + ", severity=" + this.getSeverity() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", details=" + this.getDetails() + ", propagation=" + this.getPropagation() + ", userId=" + this.getUserId() + ", edgeAlarmId=" + this.getEdgeAlarmId() + ")";
    }

    public static class AlarmCreateOrUpdateActiveRequestBuilder {
        private TenantId tenantId;
        private CustomerId customerId;
        private String type;
        private EntityId originator;
        private AlarmSeverity severity;
        private long startTs;
        private long endTs;
        private JsonNode details;
        private AlarmPropagationInfo propagation;
        private UserId userId;
        private AlarmId edgeAlarmId;

        AlarmCreateOrUpdateActiveRequestBuilder() {
        }

        public AlarmCreateOrUpdateActiveRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder propagation(AlarmPropagationInfo propagation) {
            this.propagation = propagation;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequestBuilder edgeAlarmId(AlarmId edgeAlarmId) {
            this.edgeAlarmId = edgeAlarmId;
            return this;
        }

        public AlarmCreateOrUpdateActiveRequest build() {
            return new AlarmCreateOrUpdateActiveRequest(this.tenantId, this.customerId, this.type, this.originator, this.severity, this.startTs, this.endTs, this.details, this.propagation, this.userId, this.edgeAlarmId);
        }

        public String toString() {
            return "AlarmCreateOrUpdateActiveRequest.AlarmCreateOrUpdateActiveRequestBuilder(tenantId=" + this.tenantId + ", customerId=" + this.customerId + ", type=" + this.type + ", originator=" + this.originator + ", severity=" + this.severity + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", details=" + this.details + ", propagation=" + this.propagation + ", userId=" + this.userId + ", edgeAlarmId=" + this.edgeAlarmId + ")";
        }
    }
}

