/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.io.Serializable;

@ApiModel
public class UpdateMessage
implements Serializable {
    @ApiModelProperty(position=1, value="'True' if new platform update is available.")
    private final boolean updateAvailable;
    @ApiModelProperty(position=2, value="Current ThingsBoard version.")
    private final String currentVersion;
    @ApiModelProperty(position=3, value="Latest ThingsBoard version.")
    private final String latestVersion;
    @ApiModelProperty(position=4, value="Upgrade instructions URL.")
    private final String upgradeInstructionsUrl;
    @ApiModelProperty(position=5, value="Current ThingsBoard version release notes URL.")
    private final String currentVersionReleaseNotesUrl;
    @ApiModelProperty(position=6, value="Latest ThingsBoard version release notes URL.")
    private final String latestVersionReleaseNotesUrl;

    @ConstructorProperties(value={"updateAvailable", "currentVersion", "latestVersion", "upgradeInstructionsUrl", "currentVersionReleaseNotesUrl", "latestVersionReleaseNotesUrl"})
    public UpdateMessage(boolean updateAvailable, String currentVersion, String latestVersion, String upgradeInstructionsUrl, String currentVersionReleaseNotesUrl, String latestVersionReleaseNotesUrl) {
        this.updateAvailable = updateAvailable;
        this.currentVersion = currentVersion;
        this.latestVersion = latestVersion;
        this.upgradeInstructionsUrl = upgradeInstructionsUrl;
        this.currentVersionReleaseNotesUrl = currentVersionReleaseNotesUrl;
        this.latestVersionReleaseNotesUrl = latestVersionReleaseNotesUrl;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getUpgradeInstructionsUrl() {
        return this.upgradeInstructionsUrl;
    }

    public String getCurrentVersionReleaseNotesUrl() {
        return this.currentVersionReleaseNotesUrl;
    }

    public String getLatestVersionReleaseNotesUrl() {
        return this.latestVersionReleaseNotesUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMessage)) {
            return false;
        }
        UpdateMessage other = (UpdateMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUpdateAvailable() != other.isUpdateAvailable()) {
            return false;
        }
        String this$currentVersion = this.getCurrentVersion();
        String other$currentVersion = other.getCurrentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$upgradeInstructionsUrl = this.getUpgradeInstructionsUrl();
        String other$upgradeInstructionsUrl = other.getUpgradeInstructionsUrl();
        if (this$upgradeInstructionsUrl == null ? other$upgradeInstructionsUrl != null : !this$upgradeInstructionsUrl.equals(other$upgradeInstructionsUrl)) {
            return false;
        }
        String this$currentVersionReleaseNotesUrl = this.getCurrentVersionReleaseNotesUrl();
        String other$currentVersionReleaseNotesUrl = other.getCurrentVersionReleaseNotesUrl();
        if (this$currentVersionReleaseNotesUrl == null ? other$currentVersionReleaseNotesUrl != null : !this$currentVersionReleaseNotesUrl.equals(other$currentVersionReleaseNotesUrl)) {
            return false;
        }
        String this$latestVersionReleaseNotesUrl = this.getLatestVersionReleaseNotesUrl();
        String other$latestVersionReleaseNotesUrl = other.getLatestVersionReleaseNotesUrl();
        return !(this$latestVersionReleaseNotesUrl == null ? other$latestVersionReleaseNotesUrl != null : !this$latestVersionReleaseNotesUrl.equals(other$latestVersionReleaseNotesUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdateAvailable() ? 79 : 97);
        String $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : $currentVersion.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $upgradeInstructionsUrl = this.getUpgradeInstructionsUrl();
        result = result * 59 + ($upgradeInstructionsUrl == null ? 43 : $upgradeInstructionsUrl.hashCode());
        String $currentVersionReleaseNotesUrl = this.getCurrentVersionReleaseNotesUrl();
        result = result * 59 + ($currentVersionReleaseNotesUrl == null ? 43 : $currentVersionReleaseNotesUrl.hashCode());
        String $latestVersionReleaseNotesUrl = this.getLatestVersionReleaseNotesUrl();
        result = result * 59 + ($latestVersionReleaseNotesUrl == null ? 43 : $latestVersionReleaseNotesUrl.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateMessage(updateAvailable=" + this.isUpdateAvailable() + ", currentVersion=" + this.getCurrentVersion() + ", latestVersion=" + this.getLatestVersion() + ", upgradeInstructionsUrl=" + this.getUpgradeInstructionsUrl() + ", currentVersionReleaseNotesUrl=" + this.getCurrentVersionReleaseNotesUrl() + ", latestVersionReleaseNotesUrl=" + this.getLatestVersionReleaseNotesUrl() + ")";
    }
}

