/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.OtaPackageInfo;

@ApiModel
public class SaveOtaPackageInfoRequest
extends OtaPackageInfo {
    @ApiModelProperty(position=16, value="Indicates OTA Package uses url. Should be 'true' if uses url or 'false' if will be used data.", example="true", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    boolean usesUrl;

    public SaveOtaPackageInfoRequest(OtaPackageInfo otaPackageInfo, boolean usesUrl) {
        super(otaPackageInfo);
        this.usesUrl = usesUrl;
    }

    public SaveOtaPackageInfoRequest(SaveOtaPackageInfoRequest saveOtaPackageInfoRequest) {
        super(saveOtaPackageInfoRequest);
        this.usesUrl = saveOtaPackageInfoRequest.isUsesUrl();
    }

    public boolean isUsesUrl() {
        return this.usesUrl;
    }

    public void setUsesUrl(boolean usesUrl) {
        this.usesUrl = usesUrl;
    }

    @Override
    public String toString() {
        return "SaveOtaPackageInfoRequest(usesUrl=" + this.isUsesUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveOtaPackageInfoRequest)) {
            return false;
        }
        SaveOtaPackageInfoRequest other = (SaveOtaPackageInfoRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isUsesUrl() == other.isUsesUrl();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SaveOtaPackageInfoRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUsesUrl() ? 79 : 97);
        return result;
    }

    public SaveOtaPackageInfoRequest() {
    }
}

