/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.wl;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.wl.Palette;

@ApiModel
public class PaletteSettings {
    @ApiModelProperty(position=1, value="Primary palette JSON", required=true)
    private Palette primaryPalette;
    @ApiModelProperty(position=2, value="Accent palette JSON", required=true)
    private Palette accentPalette;

    public PaletteSettings merge(PaletteSettings otherPaletteSettings) {
        if (this.primaryPalette == null || StringUtils.isEmpty(this.primaryPalette.getType())) {
            this.primaryPalette = otherPaletteSettings.primaryPalette;
        }
        if (this.accentPalette == null || StringUtils.isEmpty(this.accentPalette.getType())) {
            this.accentPalette = otherPaletteSettings.accentPalette;
        }
        return this;
    }

    public Palette getPrimaryPalette() {
        return this.primaryPalette;
    }

    public Palette getAccentPalette() {
        return this.accentPalette;
    }

    public void setPrimaryPalette(Palette primaryPalette) {
        this.primaryPalette = primaryPalette;
    }

    public void setAccentPalette(Palette accentPalette) {
        this.accentPalette = accentPalette;
    }

    public String toString() {
        return "PaletteSettings(primaryPalette=" + this.getPrimaryPalette() + ", accentPalette=" + this.getAccentPalette() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaletteSettings)) {
            return false;
        }
        PaletteSettings other = (PaletteSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Palette this$primaryPalette = this.getPrimaryPalette();
        Palette other$primaryPalette = other.getPrimaryPalette();
        if (this$primaryPalette == null ? other$primaryPalette != null : !((Object)this$primaryPalette).equals(other$primaryPalette)) {
            return false;
        }
        Palette this$accentPalette = this.getAccentPalette();
        Palette other$accentPalette = other.getAccentPalette();
        return !(this$accentPalette == null ? other$accentPalette != null : !((Object)this$accentPalette).equals(other$accentPalette));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaletteSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Palette $primaryPalette = this.getPrimaryPalette();
        result = result * 59 + ($primaryPalette == null ? 43 : ((Object)$primaryPalette).hashCode());
        Palette $accentPalette = this.getAccentPalette();
        result = result * 59 + ($accentPalette == null ? 43 : ((Object)$accentPalette).hashCode());
        return result;
    }
}

