/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.wl;

import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;

public class LoginWhiteLabelingParams
extends WhiteLabelingParams {
    @ApiModelProperty(position=16, value="Login page background color", example="#d90f0f")
    private String pageBackgroundColor;
    @ApiModelProperty(position=17, value="Enable/Disable dark foreground")
    private boolean darkForeground;
    @ApiModelProperty(position=18, value="Domain name of the login page", example="iot.mycompany.com")
    private String domainName;
    @ApiModelProperty(position=19, value="Base URL for the activation link, etc", example="https://iot.mycompany.com")
    private String baseUrl;
    @ApiModelProperty(position=20, value="Prohibit use of other URLs. It is recommended to enable this setting", example="true")
    private boolean prohibitDifferentUrl;
    @ApiModelProperty(position=21, value="Id of the settings object that store this parameters")
    private String adminSettingsId;
    @ApiModelProperty(position=22, value="Show platform name and version on login page")
    private Boolean showNameBottom;

    public LoginWhiteLabelingParams merge(LoginWhiteLabelingParams otherWlParams) {
        Integer prevLogoImageHeight = this.logoImageHeight;
        super.merge(otherWlParams);
        if (prevLogoImageHeight == null) {
            this.logoImageHeight = null;
        }
        if (this.showNameBottom == null) {
            this.showNameBottom = otherWlParams.showNameBottom;
        }
        return this;
    }

    public String getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public boolean isDarkForeground() {
        return this.darkForeground;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isProhibitDifferentUrl() {
        return this.prohibitDifferentUrl;
    }

    public String getAdminSettingsId() {
        return this.adminSettingsId;
    }

    public Boolean getShowNameBottom() {
        return this.showNameBottom;
    }

    public void setPageBackgroundColor(String pageBackgroundColor) {
        this.pageBackgroundColor = pageBackgroundColor;
    }

    public void setDarkForeground(boolean darkForeground) {
        this.darkForeground = darkForeground;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setProhibitDifferentUrl(boolean prohibitDifferentUrl) {
        this.prohibitDifferentUrl = prohibitDifferentUrl;
    }

    public void setAdminSettingsId(String adminSettingsId) {
        this.adminSettingsId = adminSettingsId;
    }

    public void setShowNameBottom(Boolean showNameBottom) {
        this.showNameBottom = showNameBottom;
    }

    @Override
    public String toString() {
        return "LoginWhiteLabelingParams(pageBackgroundColor=" + this.getPageBackgroundColor() + ", darkForeground=" + this.isDarkForeground() + ", domainName=" + this.getDomainName() + ", baseUrl=" + this.getBaseUrl() + ", prohibitDifferentUrl=" + this.isProhibitDifferentUrl() + ", adminSettingsId=" + this.getAdminSettingsId() + ", showNameBottom=" + this.getShowNameBottom() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginWhiteLabelingParams)) {
            return false;
        }
        LoginWhiteLabelingParams other = (LoginWhiteLabelingParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDarkForeground() != other.isDarkForeground()) {
            return false;
        }
        if (this.isProhibitDifferentUrl() != other.isProhibitDifferentUrl()) {
            return false;
        }
        Boolean this$showNameBottom = this.getShowNameBottom();
        Boolean other$showNameBottom = other.getShowNameBottom();
        if (this$showNameBottom == null ? other$showNameBottom != null : !((Object)this$showNameBottom).equals(other$showNameBottom)) {
            return false;
        }
        String this$pageBackgroundColor = this.getPageBackgroundColor();
        String other$pageBackgroundColor = other.getPageBackgroundColor();
        if (this$pageBackgroundColor == null ? other$pageBackgroundColor != null : !this$pageBackgroundColor.equals(other$pageBackgroundColor)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$adminSettingsId = this.getAdminSettingsId();
        String other$adminSettingsId = other.getAdminSettingsId();
        return !(this$adminSettingsId == null ? other$adminSettingsId != null : !this$adminSettingsId.equals(other$adminSettingsId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LoginWhiteLabelingParams;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDarkForeground() ? 79 : 97);
        result = result * 59 + (this.isProhibitDifferentUrl() ? 79 : 97);
        Boolean $showNameBottom = this.getShowNameBottom();
        result = result * 59 + ($showNameBottom == null ? 43 : ((Object)$showNameBottom).hashCode());
        String $pageBackgroundColor = this.getPageBackgroundColor();
        result = result * 59 + ($pageBackgroundColor == null ? 43 : $pageBackgroundColor.hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $adminSettingsId = this.getAdminSettingsId();
        result = result * 59 + ($adminSettingsId == null ? 43 : $adminSettingsId.hashCode());
        return result;
    }
}

