/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class BaseWidgetType
extends BaseData<WidgetTypeId>
implements HasName,
TenantEntity {
    private static final long serialVersionUID = 8388684344603660756L;
    @ApiModelProperty(position=3, value="JSON object with Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="bundleAlias")
    @ApiModelProperty(position=4, value="Reference to widget bundle", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String bundleAlias;
    @NoXss
    @Length(fieldName="alias")
    @ApiModelProperty(position=5, value="Unique alias that is used in dashboards as a reference widget type", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String alias;
    @NoXss
    @Length(fieldName="name")
    @ApiModelProperty(position=6, value="Widget name used in search and UI", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String name;

    public BaseWidgetType() {
    }

    public BaseWidgetType(WidgetTypeId id) {
        super(id);
    }

    public BaseWidgetType(BaseWidgetType widgetType) {
        super(widgetType);
        this.tenantId = widgetType.getTenantId();
        this.bundleAlias = widgetType.getBundleAlias();
        this.alias = widgetType.getAlias();
        this.name = widgetType.getName();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.WIDGET_TYPE;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Widget Type Id. Specify this field to update the Widget Type. Referencing non-existing Widget Type Id will cause error. Omit this field to create new Widget Type.")
    public WidgetTypeId getId() {
        return (WidgetTypeId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the Widget Type creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getBundleAlias() {
        return this.bundleAlias;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setBundleAlias(String bundleAlias) {
        this.bundleAlias = bundleAlias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWidgetType)) {
            return false;
        }
        BaseWidgetType other = (BaseWidgetType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$bundleAlias = this.getBundleAlias();
        String other$bundleAlias = other.getBundleAlias();
        if (this$bundleAlias == null ? other$bundleAlias != null : !this$bundleAlias.equals(other$bundleAlias)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWidgetType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $bundleAlias = this.getBundleAlias();
        result = result * 59 + ($bundleAlias == null ? 43 : $bundleAlias.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseWidgetType(tenantId=" + this.getTenantId() + ", bundleAlias=" + this.getBundleAlias() + ", alias=" + this.getAlias() + ", name=" + this.getName() + ")";
    }
}

