/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TemplateUtils {
    private static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\$\\{(.+?)(:[a-zA-Z]+)?}");
    private static final Map<String, UnaryOperator<String>> FUNCTIONS = Map.of("upperCase", String::toUpperCase, "lowerCase", String::toLowerCase, "capitalize", StringUtils::capitalize);

    private TemplateUtils() {
    }

    public static String processTemplate(String template, Map<String, String> context) {
        return TEMPLATE_PARAM_PATTERN.matcher(template).replaceAll(matchResult -> {
            String key = matchResult.group(1);
            if (!context.containsKey(key)) {
                return "\\" + matchResult.group();
            }
            String value = Strings.nullToEmpty((String)((String)context.get(key)));
            String function = StringUtils.removeStart((String)matchResult.group(2), (String)":");
            if (function != null && FUNCTIONS.containsKey(function)) {
                value = (String)FUNCTIONS.get(function).apply(value);
            }
            return value;
        });
    }
}

