/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectionsUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionsUtil.isEmpty(collection);
    }

    public static <T> Set<T> diffSets(Set<T> a, Set<T> b) {
        return b.stream().filter(p -> !a.contains(p)).collect(Collectors.toSet());
    }

    public static <T> boolean contains(Collection<T> collection, T element) {
        return CollectionsUtil.isNotEmpty(collection) && collection.contains(element);
    }

    public static <T> int countNonNull(T[] array) {
        int count = 0;
        for (T t : array) {
            if (t == null) continue;
            ++count;
        }
        return count;
    }

    public static <K, V> Map<K, V> mapOf(Object ... kvs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            Object key = kvs[i];
            Object value = kvs[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<K, V> unmodifiableMapOf(Object ... kvs) {
        return Collections.unmodifiableMap(CollectionsUtil.mapOf(kvs));
    }

    public static <V> boolean emptyOrContains(Collection<V> collection, V element) {
        return CollectionsUtil.isEmpty(collection) || collection.contains(element);
    }
}

