/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;

@ApiModel
public class CustomTranslation {
    private static final Logger log = LoggerFactory.getLogger(CustomTranslation.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Map of locale IDs to stringified json object with custom translations", required=true)
    private Map<String, String> translationMap = new HashMap<String, String>();

    public CustomTranslation merge(CustomTranslation otherCL) {
        ArrayList<String> languages = new ArrayList<String>(this.translationMap.keySet());
        if (otherCL != null && otherCL.getTranslationMap() != null) {
            languages.addAll(otherCL.getTranslationMap().keySet());
            for (String lang : languages) {
                JsonNode node = this.safeParse(this.translationMap.get(lang));
                JsonNode otherNode = this.safeParse(otherCL.getTranslationMap().get(lang));
                this.merge(node, otherNode);
                try {
                    this.translationMap.put(lang, OBJECT_MAPPER.writeValueAsString((Object)node));
                }
                catch (JsonProcessingException e) {
                    log.warn("Can't write object as json string", (Throwable)e);
                }
            }
        }
        return this;
    }

    private JsonNode safeParse(String jsonStr) {
        ObjectNode node = OBJECT_MAPPER.createObjectNode();
        try {
            if (StringUtils.isNoneBlank(jsonStr)) {
                node = OBJECT_MAPPER.readTree(jsonStr);
            }
        }
        catch (IOException e) {
            log.warn("Can't read json string", (Throwable)e);
        }
        return node;
    }

    private void merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode value;
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null) {
                if (jsonNode.isObject()) {
                    this.merge(jsonNode, updateNode.get(fieldName));
                    continue;
                }
                if (!jsonNode.isArray()) continue;
                for (int i = 0; i < jsonNode.size(); ++i) {
                    this.merge(jsonNode.get(i), updateNode.get(fieldName).get(i));
                }
                continue;
            }
            if (!(mainNode instanceof ObjectNode) || (value = updateNode.get(fieldName)).isNull()) continue;
            ((ObjectNode)mainNode).set(fieldName, value);
        }
    }

    public Map<String, String> getTranslationMap() {
        return this.translationMap;
    }

    public void setTranslationMap(Map<String, String> translationMap) {
        this.translationMap = translationMap;
    }

    public String toString() {
        return "CustomTranslation(translationMap=" + this.getTranslationMap() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTranslation)) {
            return false;
        }
        CustomTranslation other = (CustomTranslation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$translationMap = this.getTranslationMap();
        Map<String, String> other$translationMap = other.getTranslationMap();
        return !(this$translationMap == null ? other$translationMap != null : !((Object)this$translationMap).equals(other$translationMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTranslation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $translationMap = this.getTranslationMap();
        result = result * 59 + ($translationMap == null ? 43 : ((Object)$translationMap).hashCode());
        return result;
    }
}

