/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.tenant.profile;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfileType;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;

public class DefaultTenantProfileConfiguration
implements TenantProfileConfiguration {
    private long maxDevices;
    private long maxAssets;
    private long maxCustomers;
    private long maxUsers;
    private long maxDashboards;
    private long maxRuleChains;
    private long maxResourcesInBytes;
    private long maxOtaPackagesInBytes;
    private long maxIntegrations;
    private long maxConverters;
    private long maxSchedulerEvents;
    private String transportTenantMsgRateLimit;
    private String transportTenantTelemetryMsgRateLimit;
    private String transportTenantTelemetryDataPointsRateLimit;
    private String transportDeviceMsgRateLimit;
    private String transportDeviceTelemetryMsgRateLimit;
    private String transportDeviceTelemetryDataPointsRateLimit;
    private String tenantEntityExportRateLimit;
    private String tenantEntityImportRateLimit;
    private String tenantNotificationRequestsRateLimit;
    private String tenantNotificationRequestsPerRuleRateLimit;
    private long maxTransportMessages;
    private long maxTransportDataPoints;
    private long maxREExecutions;
    private long maxJSExecutions;
    private long maxDPStorageDays;
    private int maxRuleNodeExecutionsPerMessage;
    private long maxEmails;
    private long maxSms;
    private long maxCreatedAlarms;
    private String tenantServerRestLimitsConfiguration;
    private String customerServerRestLimitsConfiguration;
    private int maxWsSessionsPerTenant;
    private int maxWsSessionsPerCustomer;
    private int maxWsSessionsPerRegularUser;
    private int maxWsSessionsPerPublicUser;
    private int wsMsgQueueLimitPerSession;
    private long maxWsSubscriptionsPerTenant;
    private long maxWsSubscriptionsPerCustomer;
    private long maxWsSubscriptionsPerRegularUser;
    private long maxWsSubscriptionsPerPublicUser;
    private String wsUpdatesPerSessionRateLimit;
    private String cassandraQueryTenantRateLimitsConfiguration;
    private int defaultStorageTtlDays;
    private int alarmsTtlDays;
    private int rpcTtlDays;
    private double warnThreshold;

    @Override
    public long getProfileThreshold(ApiUsageRecordKey key) {
        switch (key) {
            case TRANSPORT_MSG_COUNT: {
                return this.maxTransportMessages;
            }
            case TRANSPORT_DP_COUNT: {
                return this.maxTransportDataPoints;
            }
            case JS_EXEC_COUNT: {
                return this.maxJSExecutions;
            }
            case RE_EXEC_COUNT: {
                return this.maxREExecutions;
            }
            case STORAGE_DP_COUNT: {
                return this.maxDPStorageDays;
            }
            case EMAIL_EXEC_COUNT: {
                return this.maxEmails;
            }
            case SMS_EXEC_COUNT: {
                return this.maxSms;
            }
            case CREATED_ALARMS_COUNT: {
                return this.maxCreatedAlarms;
            }
        }
        return 0L;
    }

    @Override
    public long getWarnThreshold(ApiUsageRecordKey key) {
        return (long)((double)this.getProfileThreshold(key) * (this.warnThreshold > 0.0 ? this.warnThreshold : 0.8));
    }

    public long getEntitiesLimit(EntityType entityType) {
        switch (entityType) {
            case DEVICE: {
                return this.maxDevices;
            }
            case ASSET: {
                return this.maxAssets;
            }
            case CUSTOMER: {
                return this.maxCustomers;
            }
            case USER: {
                return this.maxUsers;
            }
            case DASHBOARD: {
                return this.maxDashboards;
            }
            case RULE_CHAIN: {
                return this.maxRuleChains;
            }
            case INTEGRATION: {
                return this.maxIntegrations;
            }
            case CONVERTER: {
                return this.maxConverters;
            }
            case SCHEDULER_EVENT: {
                return this.maxSchedulerEvents;
            }
        }
        return 0L;
    }

    @Override
    public TenantProfileType getType() {
        return TenantProfileType.DEFAULT;
    }

    @Override
    public int getMaxRuleNodeExecsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    public static DefaultTenantProfileConfigurationBuilder builder() {
        return new DefaultTenantProfileConfigurationBuilder();
    }

    @ConstructorProperties(value={"maxDevices", "maxAssets", "maxCustomers", "maxUsers", "maxDashboards", "maxRuleChains", "maxResourcesInBytes", "maxOtaPackagesInBytes", "maxIntegrations", "maxConverters", "maxSchedulerEvents", "transportTenantMsgRateLimit", "transportTenantTelemetryMsgRateLimit", "transportTenantTelemetryDataPointsRateLimit", "transportDeviceMsgRateLimit", "transportDeviceTelemetryMsgRateLimit", "transportDeviceTelemetryDataPointsRateLimit", "tenantEntityExportRateLimit", "tenantEntityImportRateLimit", "tenantNotificationRequestsRateLimit", "tenantNotificationRequestsPerRuleRateLimit", "maxTransportMessages", "maxTransportDataPoints", "maxREExecutions", "maxJSExecutions", "maxDPStorageDays", "maxRuleNodeExecutionsPerMessage", "maxEmails", "maxSms", "maxCreatedAlarms", "tenantServerRestLimitsConfiguration", "customerServerRestLimitsConfiguration", "maxWsSessionsPerTenant", "maxWsSessionsPerCustomer", "maxWsSessionsPerRegularUser", "maxWsSessionsPerPublicUser", "wsMsgQueueLimitPerSession", "maxWsSubscriptionsPerTenant", "maxWsSubscriptionsPerCustomer", "maxWsSubscriptionsPerRegularUser", "maxWsSubscriptionsPerPublicUser", "wsUpdatesPerSessionRateLimit", "cassandraQueryTenantRateLimitsConfiguration", "defaultStorageTtlDays", "alarmsTtlDays", "rpcTtlDays", "warnThreshold"})
    public DefaultTenantProfileConfiguration(long maxDevices, long maxAssets, long maxCustomers, long maxUsers, long maxDashboards, long maxRuleChains, long maxResourcesInBytes, long maxOtaPackagesInBytes, long maxIntegrations, long maxConverters, long maxSchedulerEvents, String transportTenantMsgRateLimit, String transportTenantTelemetryMsgRateLimit, String transportTenantTelemetryDataPointsRateLimit, String transportDeviceMsgRateLimit, String transportDeviceTelemetryMsgRateLimit, String transportDeviceTelemetryDataPointsRateLimit, String tenantEntityExportRateLimit, String tenantEntityImportRateLimit, String tenantNotificationRequestsRateLimit, String tenantNotificationRequestsPerRuleRateLimit, long maxTransportMessages, long maxTransportDataPoints, long maxREExecutions, long maxJSExecutions, long maxDPStorageDays, int maxRuleNodeExecutionsPerMessage, long maxEmails, long maxSms, long maxCreatedAlarms, String tenantServerRestLimitsConfiguration, String customerServerRestLimitsConfiguration, int maxWsSessionsPerTenant, int maxWsSessionsPerCustomer, int maxWsSessionsPerRegularUser, int maxWsSessionsPerPublicUser, int wsMsgQueueLimitPerSession, long maxWsSubscriptionsPerTenant, long maxWsSubscriptionsPerCustomer, long maxWsSubscriptionsPerRegularUser, long maxWsSubscriptionsPerPublicUser, String wsUpdatesPerSessionRateLimit, String cassandraQueryTenantRateLimitsConfiguration, int defaultStorageTtlDays, int alarmsTtlDays, int rpcTtlDays, double warnThreshold) {
        this.maxDevices = maxDevices;
        this.maxAssets = maxAssets;
        this.maxCustomers = maxCustomers;
        this.maxUsers = maxUsers;
        this.maxDashboards = maxDashboards;
        this.maxRuleChains = maxRuleChains;
        this.maxResourcesInBytes = maxResourcesInBytes;
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
        this.maxIntegrations = maxIntegrations;
        this.maxConverters = maxConverters;
        this.maxSchedulerEvents = maxSchedulerEvents;
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
        this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
        this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
        this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
        this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
        this.maxTransportMessages = maxTransportMessages;
        this.maxTransportDataPoints = maxTransportDataPoints;
        this.maxREExecutions = maxREExecutions;
        this.maxJSExecutions = maxJSExecutions;
        this.maxDPStorageDays = maxDPStorageDays;
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
        this.maxEmails = maxEmails;
        this.maxSms = maxSms;
        this.maxCreatedAlarms = maxCreatedAlarms;
        this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
        this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
        this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
        this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
        this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
        this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
        this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
        this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
        this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
        this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
        this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
        this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
        this.cassandraQueryTenantRateLimitsConfiguration = cassandraQueryTenantRateLimitsConfiguration;
        this.defaultStorageTtlDays = defaultStorageTtlDays;
        this.alarmsTtlDays = alarmsTtlDays;
        this.rpcTtlDays = rpcTtlDays;
        this.warnThreshold = warnThreshold;
    }

    public DefaultTenantProfileConfiguration() {
    }

    public long getMaxDevices() {
        return this.maxDevices;
    }

    public long getMaxAssets() {
        return this.maxAssets;
    }

    public long getMaxCustomers() {
        return this.maxCustomers;
    }

    public long getMaxUsers() {
        return this.maxUsers;
    }

    public long getMaxDashboards() {
        return this.maxDashboards;
    }

    public long getMaxRuleChains() {
        return this.maxRuleChains;
    }

    public long getMaxResourcesInBytes() {
        return this.maxResourcesInBytes;
    }

    public long getMaxOtaPackagesInBytes() {
        return this.maxOtaPackagesInBytes;
    }

    public long getMaxIntegrations() {
        return this.maxIntegrations;
    }

    public long getMaxConverters() {
        return this.maxConverters;
    }

    public long getMaxSchedulerEvents() {
        return this.maxSchedulerEvents;
    }

    public String getTransportTenantMsgRateLimit() {
        return this.transportTenantMsgRateLimit;
    }

    public String getTransportTenantTelemetryMsgRateLimit() {
        return this.transportTenantTelemetryMsgRateLimit;
    }

    public String getTransportTenantTelemetryDataPointsRateLimit() {
        return this.transportTenantTelemetryDataPointsRateLimit;
    }

    public String getTransportDeviceMsgRateLimit() {
        return this.transportDeviceMsgRateLimit;
    }

    public String getTransportDeviceTelemetryMsgRateLimit() {
        return this.transportDeviceTelemetryMsgRateLimit;
    }

    public String getTransportDeviceTelemetryDataPointsRateLimit() {
        return this.transportDeviceTelemetryDataPointsRateLimit;
    }

    public String getTenantEntityExportRateLimit() {
        return this.tenantEntityExportRateLimit;
    }

    public String getTenantEntityImportRateLimit() {
        return this.tenantEntityImportRateLimit;
    }

    public String getTenantNotificationRequestsRateLimit() {
        return this.tenantNotificationRequestsRateLimit;
    }

    public String getTenantNotificationRequestsPerRuleRateLimit() {
        return this.tenantNotificationRequestsPerRuleRateLimit;
    }

    public long getMaxTransportMessages() {
        return this.maxTransportMessages;
    }

    public long getMaxTransportDataPoints() {
        return this.maxTransportDataPoints;
    }

    public long getMaxREExecutions() {
        return this.maxREExecutions;
    }

    public long getMaxJSExecutions() {
        return this.maxJSExecutions;
    }

    public long getMaxDPStorageDays() {
        return this.maxDPStorageDays;
    }

    public int getMaxRuleNodeExecutionsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    public long getMaxEmails() {
        return this.maxEmails;
    }

    public long getMaxSms() {
        return this.maxSms;
    }

    public long getMaxCreatedAlarms() {
        return this.maxCreatedAlarms;
    }

    public String getTenantServerRestLimitsConfiguration() {
        return this.tenantServerRestLimitsConfiguration;
    }

    public String getCustomerServerRestLimitsConfiguration() {
        return this.customerServerRestLimitsConfiguration;
    }

    public int getMaxWsSessionsPerTenant() {
        return this.maxWsSessionsPerTenant;
    }

    public int getMaxWsSessionsPerCustomer() {
        return this.maxWsSessionsPerCustomer;
    }

    public int getMaxWsSessionsPerRegularUser() {
        return this.maxWsSessionsPerRegularUser;
    }

    public int getMaxWsSessionsPerPublicUser() {
        return this.maxWsSessionsPerPublicUser;
    }

    public int getWsMsgQueueLimitPerSession() {
        return this.wsMsgQueueLimitPerSession;
    }

    public long getMaxWsSubscriptionsPerTenant() {
        return this.maxWsSubscriptionsPerTenant;
    }

    public long getMaxWsSubscriptionsPerCustomer() {
        return this.maxWsSubscriptionsPerCustomer;
    }

    public long getMaxWsSubscriptionsPerRegularUser() {
        return this.maxWsSubscriptionsPerRegularUser;
    }

    public long getMaxWsSubscriptionsPerPublicUser() {
        return this.maxWsSubscriptionsPerPublicUser;
    }

    public String getWsUpdatesPerSessionRateLimit() {
        return this.wsUpdatesPerSessionRateLimit;
    }

    public String getCassandraQueryTenantRateLimitsConfiguration() {
        return this.cassandraQueryTenantRateLimitsConfiguration;
    }

    public int getDefaultStorageTtlDays() {
        return this.defaultStorageTtlDays;
    }

    public int getAlarmsTtlDays() {
        return this.alarmsTtlDays;
    }

    public int getRpcTtlDays() {
        return this.rpcTtlDays;
    }

    public double getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setMaxDevices(long maxDevices) {
        this.maxDevices = maxDevices;
    }

    public void setMaxAssets(long maxAssets) {
        this.maxAssets = maxAssets;
    }

    public void setMaxCustomers(long maxCustomers) {
        this.maxCustomers = maxCustomers;
    }

    public void setMaxUsers(long maxUsers) {
        this.maxUsers = maxUsers;
    }

    public void setMaxDashboards(long maxDashboards) {
        this.maxDashboards = maxDashboards;
    }

    public void setMaxRuleChains(long maxRuleChains) {
        this.maxRuleChains = maxRuleChains;
    }

    public void setMaxResourcesInBytes(long maxResourcesInBytes) {
        this.maxResourcesInBytes = maxResourcesInBytes;
    }

    public void setMaxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
    }

    public void setMaxIntegrations(long maxIntegrations) {
        this.maxIntegrations = maxIntegrations;
    }

    public void setMaxConverters(long maxConverters) {
        this.maxConverters = maxConverters;
    }

    public void setMaxSchedulerEvents(long maxSchedulerEvents) {
        this.maxSchedulerEvents = maxSchedulerEvents;
    }

    public void setTransportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
    }

    public void setTransportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
    }

    public void setTransportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
    }

    public void setTransportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
    }

    public void setTransportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
    }

    public void setTransportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
    }

    public void setTenantEntityExportRateLimit(String tenantEntityExportRateLimit) {
        this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
    }

    public void setTenantEntityImportRateLimit(String tenantEntityImportRateLimit) {
        this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
    }

    public void setTenantNotificationRequestsRateLimit(String tenantNotificationRequestsRateLimit) {
        this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
    }

    public void setTenantNotificationRequestsPerRuleRateLimit(String tenantNotificationRequestsPerRuleRateLimit) {
        this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
    }

    public void setMaxTransportMessages(long maxTransportMessages) {
        this.maxTransportMessages = maxTransportMessages;
    }

    public void setMaxTransportDataPoints(long maxTransportDataPoints) {
        this.maxTransportDataPoints = maxTransportDataPoints;
    }

    public void setMaxREExecutions(long maxREExecutions) {
        this.maxREExecutions = maxREExecutions;
    }

    public void setMaxJSExecutions(long maxJSExecutions) {
        this.maxJSExecutions = maxJSExecutions;
    }

    public void setMaxDPStorageDays(long maxDPStorageDays) {
        this.maxDPStorageDays = maxDPStorageDays;
    }

    public void setMaxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
    }

    public void setMaxEmails(long maxEmails) {
        this.maxEmails = maxEmails;
    }

    public void setMaxSms(long maxSms) {
        this.maxSms = maxSms;
    }

    public void setMaxCreatedAlarms(long maxCreatedAlarms) {
        this.maxCreatedAlarms = maxCreatedAlarms;
    }

    public void setTenantServerRestLimitsConfiguration(String tenantServerRestLimitsConfiguration) {
        this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
    }

    public void setCustomerServerRestLimitsConfiguration(String customerServerRestLimitsConfiguration) {
        this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
    }

    public void setMaxWsSessionsPerTenant(int maxWsSessionsPerTenant) {
        this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
    }

    public void setMaxWsSessionsPerCustomer(int maxWsSessionsPerCustomer) {
        this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
    }

    public void setMaxWsSessionsPerRegularUser(int maxWsSessionsPerRegularUser) {
        this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
    }

    public void setMaxWsSessionsPerPublicUser(int maxWsSessionsPerPublicUser) {
        this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
    }

    public void setWsMsgQueueLimitPerSession(int wsMsgQueueLimitPerSession) {
        this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
    }

    public void setMaxWsSubscriptionsPerTenant(long maxWsSubscriptionsPerTenant) {
        this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
    }

    public void setMaxWsSubscriptionsPerCustomer(long maxWsSubscriptionsPerCustomer) {
        this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
    }

    public void setMaxWsSubscriptionsPerRegularUser(long maxWsSubscriptionsPerRegularUser) {
        this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
    }

    public void setMaxWsSubscriptionsPerPublicUser(long maxWsSubscriptionsPerPublicUser) {
        this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
    }

    public void setWsUpdatesPerSessionRateLimit(String wsUpdatesPerSessionRateLimit) {
        this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
    }

    public void setCassandraQueryTenantRateLimitsConfiguration(String cassandraQueryTenantRateLimitsConfiguration) {
        this.cassandraQueryTenantRateLimitsConfiguration = cassandraQueryTenantRateLimitsConfiguration;
    }

    public void setDefaultStorageTtlDays(int defaultStorageTtlDays) {
        this.defaultStorageTtlDays = defaultStorageTtlDays;
    }

    public void setAlarmsTtlDays(int alarmsTtlDays) {
        this.alarmsTtlDays = alarmsTtlDays;
    }

    public void setRpcTtlDays(int rpcTtlDays) {
        this.rpcTtlDays = rpcTtlDays;
    }

    public void setWarnThreshold(double warnThreshold) {
        this.warnThreshold = warnThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTenantProfileConfiguration)) {
            return false;
        }
        DefaultTenantProfileConfiguration other = (DefaultTenantProfileConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxDevices() != other.getMaxDevices()) {
            return false;
        }
        if (this.getMaxAssets() != other.getMaxAssets()) {
            return false;
        }
        if (this.getMaxCustomers() != other.getMaxCustomers()) {
            return false;
        }
        if (this.getMaxUsers() != other.getMaxUsers()) {
            return false;
        }
        if (this.getMaxDashboards() != other.getMaxDashboards()) {
            return false;
        }
        if (this.getMaxRuleChains() != other.getMaxRuleChains()) {
            return false;
        }
        if (this.getMaxResourcesInBytes() != other.getMaxResourcesInBytes()) {
            return false;
        }
        if (this.getMaxOtaPackagesInBytes() != other.getMaxOtaPackagesInBytes()) {
            return false;
        }
        if (this.getMaxIntegrations() != other.getMaxIntegrations()) {
            return false;
        }
        if (this.getMaxConverters() != other.getMaxConverters()) {
            return false;
        }
        if (this.getMaxSchedulerEvents() != other.getMaxSchedulerEvents()) {
            return false;
        }
        if (this.getMaxTransportMessages() != other.getMaxTransportMessages()) {
            return false;
        }
        if (this.getMaxTransportDataPoints() != other.getMaxTransportDataPoints()) {
            return false;
        }
        if (this.getMaxREExecutions() != other.getMaxREExecutions()) {
            return false;
        }
        if (this.getMaxJSExecutions() != other.getMaxJSExecutions()) {
            return false;
        }
        if (this.getMaxDPStorageDays() != other.getMaxDPStorageDays()) {
            return false;
        }
        if (this.getMaxRuleNodeExecutionsPerMessage() != other.getMaxRuleNodeExecutionsPerMessage()) {
            return false;
        }
        if (this.getMaxEmails() != other.getMaxEmails()) {
            return false;
        }
        if (this.getMaxSms() != other.getMaxSms()) {
            return false;
        }
        if (this.getMaxCreatedAlarms() != other.getMaxCreatedAlarms()) {
            return false;
        }
        if (this.getMaxWsSessionsPerTenant() != other.getMaxWsSessionsPerTenant()) {
            return false;
        }
        if (this.getMaxWsSessionsPerCustomer() != other.getMaxWsSessionsPerCustomer()) {
            return false;
        }
        if (this.getMaxWsSessionsPerRegularUser() != other.getMaxWsSessionsPerRegularUser()) {
            return false;
        }
        if (this.getMaxWsSessionsPerPublicUser() != other.getMaxWsSessionsPerPublicUser()) {
            return false;
        }
        if (this.getWsMsgQueueLimitPerSession() != other.getWsMsgQueueLimitPerSession()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerTenant() != other.getMaxWsSubscriptionsPerTenant()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerCustomer() != other.getMaxWsSubscriptionsPerCustomer()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerRegularUser() != other.getMaxWsSubscriptionsPerRegularUser()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerPublicUser() != other.getMaxWsSubscriptionsPerPublicUser()) {
            return false;
        }
        if (this.getDefaultStorageTtlDays() != other.getDefaultStorageTtlDays()) {
            return false;
        }
        if (this.getAlarmsTtlDays() != other.getAlarmsTtlDays()) {
            return false;
        }
        if (this.getRpcTtlDays() != other.getRpcTtlDays()) {
            return false;
        }
        if (Double.compare(this.getWarnThreshold(), other.getWarnThreshold()) != 0) {
            return false;
        }
        String this$transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        String other$transportTenantMsgRateLimit = other.getTransportTenantMsgRateLimit();
        if (this$transportTenantMsgRateLimit == null ? other$transportTenantMsgRateLimit != null : !this$transportTenantMsgRateLimit.equals(other$transportTenantMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        String other$transportTenantTelemetryMsgRateLimit = other.getTransportTenantTelemetryMsgRateLimit();
        if (this$transportTenantTelemetryMsgRateLimit == null ? other$transportTenantTelemetryMsgRateLimit != null : !this$transportTenantTelemetryMsgRateLimit.equals(other$transportTenantTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        String other$transportTenantTelemetryDataPointsRateLimit = other.getTransportTenantTelemetryDataPointsRateLimit();
        if (this$transportTenantTelemetryDataPointsRateLimit == null ? other$transportTenantTelemetryDataPointsRateLimit != null : !this$transportTenantTelemetryDataPointsRateLimit.equals(other$transportTenantTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        String other$transportDeviceMsgRateLimit = other.getTransportDeviceMsgRateLimit();
        if (this$transportDeviceMsgRateLimit == null ? other$transportDeviceMsgRateLimit != null : !this$transportDeviceMsgRateLimit.equals(other$transportDeviceMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        String other$transportDeviceTelemetryMsgRateLimit = other.getTransportDeviceTelemetryMsgRateLimit();
        if (this$transportDeviceTelemetryMsgRateLimit == null ? other$transportDeviceTelemetryMsgRateLimit != null : !this$transportDeviceTelemetryMsgRateLimit.equals(other$transportDeviceTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        String other$transportDeviceTelemetryDataPointsRateLimit = other.getTransportDeviceTelemetryDataPointsRateLimit();
        if (this$transportDeviceTelemetryDataPointsRateLimit == null ? other$transportDeviceTelemetryDataPointsRateLimit != null : !this$transportDeviceTelemetryDataPointsRateLimit.equals(other$transportDeviceTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$tenantEntityExportRateLimit = this.getTenantEntityExportRateLimit();
        String other$tenantEntityExportRateLimit = other.getTenantEntityExportRateLimit();
        if (this$tenantEntityExportRateLimit == null ? other$tenantEntityExportRateLimit != null : !this$tenantEntityExportRateLimit.equals(other$tenantEntityExportRateLimit)) {
            return false;
        }
        String this$tenantEntityImportRateLimit = this.getTenantEntityImportRateLimit();
        String other$tenantEntityImportRateLimit = other.getTenantEntityImportRateLimit();
        if (this$tenantEntityImportRateLimit == null ? other$tenantEntityImportRateLimit != null : !this$tenantEntityImportRateLimit.equals(other$tenantEntityImportRateLimit)) {
            return false;
        }
        String this$tenantNotificationRequestsRateLimit = this.getTenantNotificationRequestsRateLimit();
        String other$tenantNotificationRequestsRateLimit = other.getTenantNotificationRequestsRateLimit();
        if (this$tenantNotificationRequestsRateLimit == null ? other$tenantNotificationRequestsRateLimit != null : !this$tenantNotificationRequestsRateLimit.equals(other$tenantNotificationRequestsRateLimit)) {
            return false;
        }
        String this$tenantNotificationRequestsPerRuleRateLimit = this.getTenantNotificationRequestsPerRuleRateLimit();
        String other$tenantNotificationRequestsPerRuleRateLimit = other.getTenantNotificationRequestsPerRuleRateLimit();
        if (this$tenantNotificationRequestsPerRuleRateLimit == null ? other$tenantNotificationRequestsPerRuleRateLimit != null : !this$tenantNotificationRequestsPerRuleRateLimit.equals(other$tenantNotificationRequestsPerRuleRateLimit)) {
            return false;
        }
        String this$tenantServerRestLimitsConfiguration = this.getTenantServerRestLimitsConfiguration();
        String other$tenantServerRestLimitsConfiguration = other.getTenantServerRestLimitsConfiguration();
        if (this$tenantServerRestLimitsConfiguration == null ? other$tenantServerRestLimitsConfiguration != null : !this$tenantServerRestLimitsConfiguration.equals(other$tenantServerRestLimitsConfiguration)) {
            return false;
        }
        String this$customerServerRestLimitsConfiguration = this.getCustomerServerRestLimitsConfiguration();
        String other$customerServerRestLimitsConfiguration = other.getCustomerServerRestLimitsConfiguration();
        if (this$customerServerRestLimitsConfiguration == null ? other$customerServerRestLimitsConfiguration != null : !this$customerServerRestLimitsConfiguration.equals(other$customerServerRestLimitsConfiguration)) {
            return false;
        }
        String this$wsUpdatesPerSessionRateLimit = this.getWsUpdatesPerSessionRateLimit();
        String other$wsUpdatesPerSessionRateLimit = other.getWsUpdatesPerSessionRateLimit();
        if (this$wsUpdatesPerSessionRateLimit == null ? other$wsUpdatesPerSessionRateLimit != null : !this$wsUpdatesPerSessionRateLimit.equals(other$wsUpdatesPerSessionRateLimit)) {
            return false;
        }
        String this$cassandraQueryTenantRateLimitsConfiguration = this.getCassandraQueryTenantRateLimitsConfiguration();
        String other$cassandraQueryTenantRateLimitsConfiguration = other.getCassandraQueryTenantRateLimitsConfiguration();
        return !(this$cassandraQueryTenantRateLimitsConfiguration == null ? other$cassandraQueryTenantRateLimitsConfiguration != null : !this$cassandraQueryTenantRateLimitsConfiguration.equals(other$cassandraQueryTenantRateLimitsConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTenantProfileConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxDevices = this.getMaxDevices();
        result = result * 59 + (int)($maxDevices >>> 32 ^ $maxDevices);
        long $maxAssets = this.getMaxAssets();
        result = result * 59 + (int)($maxAssets >>> 32 ^ $maxAssets);
        long $maxCustomers = this.getMaxCustomers();
        result = result * 59 + (int)($maxCustomers >>> 32 ^ $maxCustomers);
        long $maxUsers = this.getMaxUsers();
        result = result * 59 + (int)($maxUsers >>> 32 ^ $maxUsers);
        long $maxDashboards = this.getMaxDashboards();
        result = result * 59 + (int)($maxDashboards >>> 32 ^ $maxDashboards);
        long $maxRuleChains = this.getMaxRuleChains();
        result = result * 59 + (int)($maxRuleChains >>> 32 ^ $maxRuleChains);
        long $maxResourcesInBytes = this.getMaxResourcesInBytes();
        result = result * 59 + (int)($maxResourcesInBytes >>> 32 ^ $maxResourcesInBytes);
        long $maxOtaPackagesInBytes = this.getMaxOtaPackagesInBytes();
        result = result * 59 + (int)($maxOtaPackagesInBytes >>> 32 ^ $maxOtaPackagesInBytes);
        long $maxIntegrations = this.getMaxIntegrations();
        result = result * 59 + (int)($maxIntegrations >>> 32 ^ $maxIntegrations);
        long $maxConverters = this.getMaxConverters();
        result = result * 59 + (int)($maxConverters >>> 32 ^ $maxConverters);
        long $maxSchedulerEvents = this.getMaxSchedulerEvents();
        result = result * 59 + (int)($maxSchedulerEvents >>> 32 ^ $maxSchedulerEvents);
        long $maxTransportMessages = this.getMaxTransportMessages();
        result = result * 59 + (int)($maxTransportMessages >>> 32 ^ $maxTransportMessages);
        long $maxTransportDataPoints = this.getMaxTransportDataPoints();
        result = result * 59 + (int)($maxTransportDataPoints >>> 32 ^ $maxTransportDataPoints);
        long $maxREExecutions = this.getMaxREExecutions();
        result = result * 59 + (int)($maxREExecutions >>> 32 ^ $maxREExecutions);
        long $maxJSExecutions = this.getMaxJSExecutions();
        result = result * 59 + (int)($maxJSExecutions >>> 32 ^ $maxJSExecutions);
        long $maxDPStorageDays = this.getMaxDPStorageDays();
        result = result * 59 + (int)($maxDPStorageDays >>> 32 ^ $maxDPStorageDays);
        result = result * 59 + this.getMaxRuleNodeExecutionsPerMessage();
        long $maxEmails = this.getMaxEmails();
        result = result * 59 + (int)($maxEmails >>> 32 ^ $maxEmails);
        long $maxSms = this.getMaxSms();
        result = result * 59 + (int)($maxSms >>> 32 ^ $maxSms);
        long $maxCreatedAlarms = this.getMaxCreatedAlarms();
        result = result * 59 + (int)($maxCreatedAlarms >>> 32 ^ $maxCreatedAlarms);
        result = result * 59 + this.getMaxWsSessionsPerTenant();
        result = result * 59 + this.getMaxWsSessionsPerCustomer();
        result = result * 59 + this.getMaxWsSessionsPerRegularUser();
        result = result * 59 + this.getMaxWsSessionsPerPublicUser();
        result = result * 59 + this.getWsMsgQueueLimitPerSession();
        long $maxWsSubscriptionsPerTenant = this.getMaxWsSubscriptionsPerTenant();
        result = result * 59 + (int)($maxWsSubscriptionsPerTenant >>> 32 ^ $maxWsSubscriptionsPerTenant);
        long $maxWsSubscriptionsPerCustomer = this.getMaxWsSubscriptionsPerCustomer();
        result = result * 59 + (int)($maxWsSubscriptionsPerCustomer >>> 32 ^ $maxWsSubscriptionsPerCustomer);
        long $maxWsSubscriptionsPerRegularUser = this.getMaxWsSubscriptionsPerRegularUser();
        result = result * 59 + (int)($maxWsSubscriptionsPerRegularUser >>> 32 ^ $maxWsSubscriptionsPerRegularUser);
        long $maxWsSubscriptionsPerPublicUser = this.getMaxWsSubscriptionsPerPublicUser();
        result = result * 59 + (int)($maxWsSubscriptionsPerPublicUser >>> 32 ^ $maxWsSubscriptionsPerPublicUser);
        result = result * 59 + this.getDefaultStorageTtlDays();
        result = result * 59 + this.getAlarmsTtlDays();
        result = result * 59 + this.getRpcTtlDays();
        long $warnThreshold = Double.doubleToLongBits(this.getWarnThreshold());
        result = result * 59 + (int)($warnThreshold >>> 32 ^ $warnThreshold);
        String $transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        result = result * 59 + ($transportTenantMsgRateLimit == null ? 43 : $transportTenantMsgRateLimit.hashCode());
        String $transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        result = result * 59 + ($transportTenantTelemetryMsgRateLimit == null ? 43 : $transportTenantTelemetryMsgRateLimit.hashCode());
        String $transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportTenantTelemetryDataPointsRateLimit == null ? 43 : $transportTenantTelemetryDataPointsRateLimit.hashCode());
        String $transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        result = result * 59 + ($transportDeviceMsgRateLimit == null ? 43 : $transportDeviceMsgRateLimit.hashCode());
        String $transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        result = result * 59 + ($transportDeviceTelemetryMsgRateLimit == null ? 43 : $transportDeviceTelemetryMsgRateLimit.hashCode());
        String $transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportDeviceTelemetryDataPointsRateLimit == null ? 43 : $transportDeviceTelemetryDataPointsRateLimit.hashCode());
        String $tenantEntityExportRateLimit = this.getTenantEntityExportRateLimit();
        result = result * 59 + ($tenantEntityExportRateLimit == null ? 43 : $tenantEntityExportRateLimit.hashCode());
        String $tenantEntityImportRateLimit = this.getTenantEntityImportRateLimit();
        result = result * 59 + ($tenantEntityImportRateLimit == null ? 43 : $tenantEntityImportRateLimit.hashCode());
        String $tenantNotificationRequestsRateLimit = this.getTenantNotificationRequestsRateLimit();
        result = result * 59 + ($tenantNotificationRequestsRateLimit == null ? 43 : $tenantNotificationRequestsRateLimit.hashCode());
        String $tenantNotificationRequestsPerRuleRateLimit = this.getTenantNotificationRequestsPerRuleRateLimit();
        result = result * 59 + ($tenantNotificationRequestsPerRuleRateLimit == null ? 43 : $tenantNotificationRequestsPerRuleRateLimit.hashCode());
        String $tenantServerRestLimitsConfiguration = this.getTenantServerRestLimitsConfiguration();
        result = result * 59 + ($tenantServerRestLimitsConfiguration == null ? 43 : $tenantServerRestLimitsConfiguration.hashCode());
        String $customerServerRestLimitsConfiguration = this.getCustomerServerRestLimitsConfiguration();
        result = result * 59 + ($customerServerRestLimitsConfiguration == null ? 43 : $customerServerRestLimitsConfiguration.hashCode());
        String $wsUpdatesPerSessionRateLimit = this.getWsUpdatesPerSessionRateLimit();
        result = result * 59 + ($wsUpdatesPerSessionRateLimit == null ? 43 : $wsUpdatesPerSessionRateLimit.hashCode());
        String $cassandraQueryTenantRateLimitsConfiguration = this.getCassandraQueryTenantRateLimitsConfiguration();
        result = result * 59 + ($cassandraQueryTenantRateLimitsConfiguration == null ? 43 : $cassandraQueryTenantRateLimitsConfiguration.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTenantProfileConfiguration(maxDevices=" + this.getMaxDevices() + ", maxAssets=" + this.getMaxAssets() + ", maxCustomers=" + this.getMaxCustomers() + ", maxUsers=" + this.getMaxUsers() + ", maxDashboards=" + this.getMaxDashboards() + ", maxRuleChains=" + this.getMaxRuleChains() + ", maxResourcesInBytes=" + this.getMaxResourcesInBytes() + ", maxOtaPackagesInBytes=" + this.getMaxOtaPackagesInBytes() + ", maxIntegrations=" + this.getMaxIntegrations() + ", maxConverters=" + this.getMaxConverters() + ", maxSchedulerEvents=" + this.getMaxSchedulerEvents() + ", transportTenantMsgRateLimit=" + this.getTransportTenantMsgRateLimit() + ", transportTenantTelemetryMsgRateLimit=" + this.getTransportTenantTelemetryMsgRateLimit() + ", transportTenantTelemetryDataPointsRateLimit=" + this.getTransportTenantTelemetryDataPointsRateLimit() + ", transportDeviceMsgRateLimit=" + this.getTransportDeviceMsgRateLimit() + ", transportDeviceTelemetryMsgRateLimit=" + this.getTransportDeviceTelemetryMsgRateLimit() + ", transportDeviceTelemetryDataPointsRateLimit=" + this.getTransportDeviceTelemetryDataPointsRateLimit() + ", tenantEntityExportRateLimit=" + this.getTenantEntityExportRateLimit() + ", tenantEntityImportRateLimit=" + this.getTenantEntityImportRateLimit() + ", tenantNotificationRequestsRateLimit=" + this.getTenantNotificationRequestsRateLimit() + ", tenantNotificationRequestsPerRuleRateLimit=" + this.getTenantNotificationRequestsPerRuleRateLimit() + ", maxTransportMessages=" + this.getMaxTransportMessages() + ", maxTransportDataPoints=" + this.getMaxTransportDataPoints() + ", maxREExecutions=" + this.getMaxREExecutions() + ", maxJSExecutions=" + this.getMaxJSExecutions() + ", maxDPStorageDays=" + this.getMaxDPStorageDays() + ", maxRuleNodeExecutionsPerMessage=" + this.getMaxRuleNodeExecutionsPerMessage() + ", maxEmails=" + this.getMaxEmails() + ", maxSms=" + this.getMaxSms() + ", maxCreatedAlarms=" + this.getMaxCreatedAlarms() + ", tenantServerRestLimitsConfiguration=" + this.getTenantServerRestLimitsConfiguration() + ", customerServerRestLimitsConfiguration=" + this.getCustomerServerRestLimitsConfiguration() + ", maxWsSessionsPerTenant=" + this.getMaxWsSessionsPerTenant() + ", maxWsSessionsPerCustomer=" + this.getMaxWsSessionsPerCustomer() + ", maxWsSessionsPerRegularUser=" + this.getMaxWsSessionsPerRegularUser() + ", maxWsSessionsPerPublicUser=" + this.getMaxWsSessionsPerPublicUser() + ", wsMsgQueueLimitPerSession=" + this.getWsMsgQueueLimitPerSession() + ", maxWsSubscriptionsPerTenant=" + this.getMaxWsSubscriptionsPerTenant() + ", maxWsSubscriptionsPerCustomer=" + this.getMaxWsSubscriptionsPerCustomer() + ", maxWsSubscriptionsPerRegularUser=" + this.getMaxWsSubscriptionsPerRegularUser() + ", maxWsSubscriptionsPerPublicUser=" + this.getMaxWsSubscriptionsPerPublicUser() + ", wsUpdatesPerSessionRateLimit=" + this.getWsUpdatesPerSessionRateLimit() + ", cassandraQueryTenantRateLimitsConfiguration=" + this.getCassandraQueryTenantRateLimitsConfiguration() + ", defaultStorageTtlDays=" + this.getDefaultStorageTtlDays() + ", alarmsTtlDays=" + this.getAlarmsTtlDays() + ", rpcTtlDays=" + this.getRpcTtlDays() + ", warnThreshold=" + this.getWarnThreshold() + ")";
    }

    public static class DefaultTenantProfileConfigurationBuilder {
        private long maxDevices;
        private long maxAssets;
        private long maxCustomers;
        private long maxUsers;
        private long maxDashboards;
        private long maxRuleChains;
        private long maxResourcesInBytes;
        private long maxOtaPackagesInBytes;
        private long maxIntegrations;
        private long maxConverters;
        private long maxSchedulerEvents;
        private String transportTenantMsgRateLimit;
        private String transportTenantTelemetryMsgRateLimit;
        private String transportTenantTelemetryDataPointsRateLimit;
        private String transportDeviceMsgRateLimit;
        private String transportDeviceTelemetryMsgRateLimit;
        private String transportDeviceTelemetryDataPointsRateLimit;
        private String tenantEntityExportRateLimit;
        private String tenantEntityImportRateLimit;
        private String tenantNotificationRequestsRateLimit;
        private String tenantNotificationRequestsPerRuleRateLimit;
        private long maxTransportMessages;
        private long maxTransportDataPoints;
        private long maxREExecutions;
        private long maxJSExecutions;
        private long maxDPStorageDays;
        private int maxRuleNodeExecutionsPerMessage;
        private long maxEmails;
        private long maxSms;
        private long maxCreatedAlarms;
        private String tenantServerRestLimitsConfiguration;
        private String customerServerRestLimitsConfiguration;
        private int maxWsSessionsPerTenant;
        private int maxWsSessionsPerCustomer;
        private int maxWsSessionsPerRegularUser;
        private int maxWsSessionsPerPublicUser;
        private int wsMsgQueueLimitPerSession;
        private long maxWsSubscriptionsPerTenant;
        private long maxWsSubscriptionsPerCustomer;
        private long maxWsSubscriptionsPerRegularUser;
        private long maxWsSubscriptionsPerPublicUser;
        private String wsUpdatesPerSessionRateLimit;
        private String cassandraQueryTenantRateLimitsConfiguration;
        private int defaultStorageTtlDays;
        private int alarmsTtlDays;
        private int rpcTtlDays;
        private double warnThreshold;

        DefaultTenantProfileConfigurationBuilder() {
        }

        public DefaultTenantProfileConfigurationBuilder maxDevices(long maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxAssets(long maxAssets) {
            this.maxAssets = maxAssets;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxCustomers(long maxCustomers) {
            this.maxCustomers = maxCustomers;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxUsers(long maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxDashboards(long maxDashboards) {
            this.maxDashboards = maxDashboards;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxRuleChains(long maxRuleChains) {
            this.maxRuleChains = maxRuleChains;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxResourcesInBytes(long maxResourcesInBytes) {
            this.maxResourcesInBytes = maxResourcesInBytes;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
            this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxIntegrations(long maxIntegrations) {
            this.maxIntegrations = maxIntegrations;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxConverters(long maxConverters) {
            this.maxConverters = maxConverters;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxSchedulerEvents(long maxSchedulerEvents) {
            this.maxSchedulerEvents = maxSchedulerEvents;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
            this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
            this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
            this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
            this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
            this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
            this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder tenantEntityExportRateLimit(String tenantEntityExportRateLimit) {
            this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder tenantEntityImportRateLimit(String tenantEntityImportRateLimit) {
            this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder tenantNotificationRequestsRateLimit(String tenantNotificationRequestsRateLimit) {
            this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder tenantNotificationRequestsPerRuleRateLimit(String tenantNotificationRequestsPerRuleRateLimit) {
            this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxTransportMessages(long maxTransportMessages) {
            this.maxTransportMessages = maxTransportMessages;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxTransportDataPoints(long maxTransportDataPoints) {
            this.maxTransportDataPoints = maxTransportDataPoints;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxREExecutions(long maxREExecutions) {
            this.maxREExecutions = maxREExecutions;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxJSExecutions(long maxJSExecutions) {
            this.maxJSExecutions = maxJSExecutions;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxDPStorageDays(long maxDPStorageDays) {
            this.maxDPStorageDays = maxDPStorageDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
            this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxEmails(long maxEmails) {
            this.maxEmails = maxEmails;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxSms(long maxSms) {
            this.maxSms = maxSms;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxCreatedAlarms(long maxCreatedAlarms) {
            this.maxCreatedAlarms = maxCreatedAlarms;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder tenantServerRestLimitsConfiguration(String tenantServerRestLimitsConfiguration) {
            this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder customerServerRestLimitsConfiguration(String customerServerRestLimitsConfiguration) {
            this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerTenant(int maxWsSessionsPerTenant) {
            this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerCustomer(int maxWsSessionsPerCustomer) {
            this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerRegularUser(int maxWsSessionsPerRegularUser) {
            this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerPublicUser(int maxWsSessionsPerPublicUser) {
            this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder wsMsgQueueLimitPerSession(int wsMsgQueueLimitPerSession) {
            this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerTenant(long maxWsSubscriptionsPerTenant) {
            this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerCustomer(long maxWsSubscriptionsPerCustomer) {
            this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerRegularUser(long maxWsSubscriptionsPerRegularUser) {
            this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerPublicUser(long maxWsSubscriptionsPerPublicUser) {
            this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder wsUpdatesPerSessionRateLimit(String wsUpdatesPerSessionRateLimit) {
            this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder cassandraQueryTenantRateLimitsConfiguration(String cassandraQueryTenantRateLimitsConfiguration) {
            this.cassandraQueryTenantRateLimitsConfiguration = cassandraQueryTenantRateLimitsConfiguration;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder defaultStorageTtlDays(int defaultStorageTtlDays) {
            this.defaultStorageTtlDays = defaultStorageTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder alarmsTtlDays(int alarmsTtlDays) {
            this.alarmsTtlDays = alarmsTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder rpcTtlDays(int rpcTtlDays) {
            this.rpcTtlDays = rpcTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder warnThreshold(double warnThreshold) {
            this.warnThreshold = warnThreshold;
            return this;
        }

        public DefaultTenantProfileConfiguration build() {
            return new DefaultTenantProfileConfiguration(this.maxDevices, this.maxAssets, this.maxCustomers, this.maxUsers, this.maxDashboards, this.maxRuleChains, this.maxResourcesInBytes, this.maxOtaPackagesInBytes, this.maxIntegrations, this.maxConverters, this.maxSchedulerEvents, this.transportTenantMsgRateLimit, this.transportTenantTelemetryMsgRateLimit, this.transportTenantTelemetryDataPointsRateLimit, this.transportDeviceMsgRateLimit, this.transportDeviceTelemetryMsgRateLimit, this.transportDeviceTelemetryDataPointsRateLimit, this.tenantEntityExportRateLimit, this.tenantEntityImportRateLimit, this.tenantNotificationRequestsRateLimit, this.tenantNotificationRequestsPerRuleRateLimit, this.maxTransportMessages, this.maxTransportDataPoints, this.maxREExecutions, this.maxJSExecutions, this.maxDPStorageDays, this.maxRuleNodeExecutionsPerMessage, this.maxEmails, this.maxSms, this.maxCreatedAlarms, this.tenantServerRestLimitsConfiguration, this.customerServerRestLimitsConfiguration, this.maxWsSessionsPerTenant, this.maxWsSessionsPerCustomer, this.maxWsSessionsPerRegularUser, this.maxWsSessionsPerPublicUser, this.wsMsgQueueLimitPerSession, this.maxWsSubscriptionsPerTenant, this.maxWsSubscriptionsPerCustomer, this.maxWsSubscriptionsPerRegularUser, this.maxWsSubscriptionsPerPublicUser, this.wsUpdatesPerSessionRateLimit, this.cassandraQueryTenantRateLimitsConfiguration, this.defaultStorageTtlDays, this.alarmsTtlDays, this.rpcTtlDays, this.warnThreshold);
        }

        public String toString() {
            return "DefaultTenantProfileConfiguration.DefaultTenantProfileConfigurationBuilder(maxDevices=" + this.maxDevices + ", maxAssets=" + this.maxAssets + ", maxCustomers=" + this.maxCustomers + ", maxUsers=" + this.maxUsers + ", maxDashboards=" + this.maxDashboards + ", maxRuleChains=" + this.maxRuleChains + ", maxResourcesInBytes=" + this.maxResourcesInBytes + ", maxOtaPackagesInBytes=" + this.maxOtaPackagesInBytes + ", maxIntegrations=" + this.maxIntegrations + ", maxConverters=" + this.maxConverters + ", maxSchedulerEvents=" + this.maxSchedulerEvents + ", transportTenantMsgRateLimit=" + this.transportTenantMsgRateLimit + ", transportTenantTelemetryMsgRateLimit=" + this.transportTenantTelemetryMsgRateLimit + ", transportTenantTelemetryDataPointsRateLimit=" + this.transportTenantTelemetryDataPointsRateLimit + ", transportDeviceMsgRateLimit=" + this.transportDeviceMsgRateLimit + ", transportDeviceTelemetryMsgRateLimit=" + this.transportDeviceTelemetryMsgRateLimit + ", transportDeviceTelemetryDataPointsRateLimit=" + this.transportDeviceTelemetryDataPointsRateLimit + ", tenantEntityExportRateLimit=" + this.tenantEntityExportRateLimit + ", tenantEntityImportRateLimit=" + this.tenantEntityImportRateLimit + ", tenantNotificationRequestsRateLimit=" + this.tenantNotificationRequestsRateLimit + ", tenantNotificationRequestsPerRuleRateLimit=" + this.tenantNotificationRequestsPerRuleRateLimit + ", maxTransportMessages=" + this.maxTransportMessages + ", maxTransportDataPoints=" + this.maxTransportDataPoints + ", maxREExecutions=" + this.maxREExecutions + ", maxJSExecutions=" + this.maxJSExecutions + ", maxDPStorageDays=" + this.maxDPStorageDays + ", maxRuleNodeExecutionsPerMessage=" + this.maxRuleNodeExecutionsPerMessage + ", maxEmails=" + this.maxEmails + ", maxSms=" + this.maxSms + ", maxCreatedAlarms=" + this.maxCreatedAlarms + ", tenantServerRestLimitsConfiguration=" + this.tenantServerRestLimitsConfiguration + ", customerServerRestLimitsConfiguration=" + this.customerServerRestLimitsConfiguration + ", maxWsSessionsPerTenant=" + this.maxWsSessionsPerTenant + ", maxWsSessionsPerCustomer=" + this.maxWsSessionsPerCustomer + ", maxWsSessionsPerRegularUser=" + this.maxWsSessionsPerRegularUser + ", maxWsSessionsPerPublicUser=" + this.maxWsSessionsPerPublicUser + ", wsMsgQueueLimitPerSession=" + this.wsMsgQueueLimitPerSession + ", maxWsSubscriptionsPerTenant=" + this.maxWsSubscriptionsPerTenant + ", maxWsSubscriptionsPerCustomer=" + this.maxWsSubscriptionsPerCustomer + ", maxWsSubscriptionsPerRegularUser=" + this.maxWsSubscriptionsPerRegularUser + ", maxWsSubscriptionsPerPublicUser=" + this.maxWsSubscriptionsPerPublicUser + ", wsUpdatesPerSessionRateLimit=" + this.wsUpdatesPerSessionRateLimit + ", cassandraQueryTenantRateLimitsConfiguration=" + this.cassandraQueryTenantRateLimitsConfiguration + ", defaultStorageTtlDays=" + this.defaultStorageTtlDays + ", alarmsTtlDays=" + this.alarmsTtlDays + ", rpcTtlDays=" + this.rpcTtlDays + ", warnThreshold=" + this.warnThreshold + ")";
        }
    }
}

