/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sms.config;

import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.sms.config.SmsProviderConfiguration;
import org.thingsboard.server.common.data.sms.config.SmsProviderType;

public class SmppSmsProviderConfiguration
implements SmsProviderConfiguration {
    @ApiModelProperty(value="SMPP version", allowableValues="3.3, 3.4", required=true)
    private String protocolVersion;
    @ApiModelProperty(value="SMPP host", required=true)
    private String host;
    @ApiModelProperty(value="SMPP port", required=true)
    private Integer port;
    @ApiModelProperty(value="System ID", required=true)
    private String systemId;
    @ApiModelProperty(value="Password", required=true)
    private String password;
    @ApiModelProperty(value="System type", required=false)
    private String systemType;
    @ApiModelProperty(value="TX - Transmitter, RX - Receiver, TRX - Transciever. By default TX is used", required=false)
    private SmppBindType bindType;
    @ApiModelProperty(value="Service type", required=false)
    private String serviceType;
    @ApiModelProperty(value="Source address", required=false)
    private String sourceAddress;
    @ApiModelProperty(value="Source TON (Type of Number). Needed is source address is set. 5 by default.\n0 - Unknown\n1 - International\n2 - National\n3 - Network Specific\n4 - Subscriber Number\n5 - Alphanumeric\n6 - Abbreviated", required=false)
    private Byte sourceTon;
    @ApiModelProperty(value="Source NPI (Numbering Plan Identification). Needed is source address is set. 0 by default.\n0 - Unknown\n1 - ISDN/telephone numbering plan (E163/E164)\n3 - Data numbering plan (X.121)\n4 - Telex numbering plan (F.69)\n6 - Land Mobile (E.212) =6\n8 - National numbering plan\n9 - Private numbering plan\n10 - ERMES numbering plan (ETSI DE/PS 3 01-3)\n13 - Internet (IP)\n18 - WAP Client Id (to be defined by WAP Forum)", required=false)
    private Byte sourceNpi;
    @ApiModelProperty(value="Destination TON (Type of Number). 5 by default.\n0 - Unknown\n1 - International\n2 - National\n3 - Network Specific\n4 - Subscriber Number\n5 - Alphanumeric\n6 - Abbreviated", required=false)
    private Byte destinationTon;
    @ApiModelProperty(value="Destination NPI (Numbering Plan Identification). 0 by default.\n0 - Unknown\n1 - ISDN/telephone numbering plan (E163/E164)\n3 - Data numbering plan (X.121)\n4 - Telex numbering plan (F.69)\n6 - Land Mobile (E.212) =6\n8 - National numbering plan\n9 - Private numbering plan\n10 - ERMES numbering plan (ETSI DE/PS 3 01-3)\n13 - Internet (IP)\n18 - WAP Client Id (to be defined by WAP Forum)", required=false)
    private Byte destinationNpi;
    @ApiModelProperty(value="Address range", required=false)
    private String addressRange;
    @ApiModelProperty(allowableValues="0-10,13-14", value="0 - SMSC Default Alphabet (ASCII for short and long code and to GSM for toll-free, used as default)\n1 - IA5 (ASCII for short and long code, Latin 9 for toll-free (ISO-8859-9))\n2 - Octet Unspecified (8-bit binary)\n3 - Latin 1 (ISO-8859-1)\n4 - Octet Unspecified (8-bit binary)\n5 - JIS (X 0208-1990)\n6 - Cyrillic (ISO-8859-5)\n7 - Latin/Hebrew (ISO-8859-8)\n8 - UCS2/UTF-16 (ISO/IEC-10646)\n9 - Pictogram Encoding\n10 - Music Codes (ISO-2022-JP)\n13 - Extended Kanji JIS (X 0212-1990)\n14 - Korean Graphic Character Set (KS C 5601/KS X 1001)", required=false)
    private Byte codingScheme;

    @Override
    public SmsProviderType getType() {
        return SmsProviderType.SMPP;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public SmppBindType getBindType() {
        return this.bindType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public Byte getSourceTon() {
        return this.sourceTon;
    }

    public Byte getSourceNpi() {
        return this.sourceNpi;
    }

    public Byte getDestinationTon() {
        return this.destinationTon;
    }

    public Byte getDestinationNpi() {
        return this.destinationNpi;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public Byte getCodingScheme() {
        return this.codingScheme;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public void setBindType(SmppBindType bindType) {
        this.bindType = bindType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public void setSourceTon(Byte sourceTon) {
        this.sourceTon = sourceTon;
    }

    public void setSourceNpi(Byte sourceNpi) {
        this.sourceNpi = sourceNpi;
    }

    public void setDestinationTon(Byte destinationTon) {
        this.destinationTon = destinationTon;
    }

    public void setDestinationNpi(Byte destinationNpi) {
        this.destinationNpi = destinationNpi;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public void setCodingScheme(Byte codingScheme) {
        this.codingScheme = codingScheme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmppSmsProviderConfiguration)) {
            return false;
        }
        SmppSmsProviderConfiguration other = (SmppSmsProviderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Byte this$sourceTon = this.getSourceTon();
        Byte other$sourceTon = other.getSourceTon();
        if (this$sourceTon == null ? other$sourceTon != null : !((Object)this$sourceTon).equals(other$sourceTon)) {
            return false;
        }
        Byte this$sourceNpi = this.getSourceNpi();
        Byte other$sourceNpi = other.getSourceNpi();
        if (this$sourceNpi == null ? other$sourceNpi != null : !((Object)this$sourceNpi).equals(other$sourceNpi)) {
            return false;
        }
        Byte this$destinationTon = this.getDestinationTon();
        Byte other$destinationTon = other.getDestinationTon();
        if (this$destinationTon == null ? other$destinationTon != null : !((Object)this$destinationTon).equals(other$destinationTon)) {
            return false;
        }
        Byte this$destinationNpi = this.getDestinationNpi();
        Byte other$destinationNpi = other.getDestinationNpi();
        if (this$destinationNpi == null ? other$destinationNpi != null : !((Object)this$destinationNpi).equals(other$destinationNpi)) {
            return false;
        }
        Byte this$codingScheme = this.getCodingScheme();
        Byte other$codingScheme = other.getCodingScheme();
        if (this$codingScheme == null ? other$codingScheme != null : !((Object)this$codingScheme).equals(other$codingScheme)) {
            return false;
        }
        String this$protocolVersion = this.getProtocolVersion();
        String other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$systemType = this.getSystemType();
        String other$systemType = other.getSystemType();
        if (this$systemType == null ? other$systemType != null : !this$systemType.equals(other$systemType)) {
            return false;
        }
        SmppBindType this$bindType = this.getBindType();
        SmppBindType other$bindType = other.getBindType();
        if (this$bindType == null ? other$bindType != null : !((Object)((Object)this$bindType)).equals((Object)other$bindType)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) {
            return false;
        }
        String this$sourceAddress = this.getSourceAddress();
        String other$sourceAddress = other.getSourceAddress();
        if (this$sourceAddress == null ? other$sourceAddress != null : !this$sourceAddress.equals(other$sourceAddress)) {
            return false;
        }
        String this$addressRange = this.getAddressRange();
        String other$addressRange = other.getAddressRange();
        return !(this$addressRange == null ? other$addressRange != null : !this$addressRange.equals(other$addressRange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmppSmsProviderConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Byte $sourceTon = this.getSourceTon();
        result = result * 59 + ($sourceTon == null ? 43 : ((Object)$sourceTon).hashCode());
        Byte $sourceNpi = this.getSourceNpi();
        result = result * 59 + ($sourceNpi == null ? 43 : ((Object)$sourceNpi).hashCode());
        Byte $destinationTon = this.getDestinationTon();
        result = result * 59 + ($destinationTon == null ? 43 : ((Object)$destinationTon).hashCode());
        Byte $destinationNpi = this.getDestinationNpi();
        result = result * 59 + ($destinationNpi == null ? 43 : ((Object)$destinationNpi).hashCode());
        Byte $codingScheme = this.getCodingScheme();
        result = result * 59 + ($codingScheme == null ? 43 : ((Object)$codingScheme).hashCode());
        String $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $systemType = this.getSystemType();
        result = result * 59 + ($systemType == null ? 43 : $systemType.hashCode());
        SmppBindType $bindType = this.getBindType();
        result = result * 59 + ($bindType == null ? 43 : ((Object)((Object)$bindType)).hashCode());
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        String $sourceAddress = this.getSourceAddress();
        result = result * 59 + ($sourceAddress == null ? 43 : $sourceAddress.hashCode());
        String $addressRange = this.getAddressRange();
        result = result * 59 + ($addressRange == null ? 43 : $addressRange.hashCode());
        return result;
    }

    public String toString() {
        return "SmppSmsProviderConfiguration(protocolVersion=" + this.getProtocolVersion() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", systemId=" + this.getSystemId() + ", password=" + this.getPassword() + ", systemType=" + this.getSystemType() + ", bindType=" + this.getBindType() + ", serviceType=" + this.getServiceType() + ", sourceAddress=" + this.getSourceAddress() + ", sourceTon=" + this.getSourceTon() + ", sourceNpi=" + this.getSourceNpi() + ", destinationTon=" + this.getDestinationTon() + ", destinationNpi=" + this.getDestinationNpi() + ", addressRange=" + this.getAddressRange() + ", codingScheme=" + this.getCodingScheme() + ")";
    }

    public static enum SmppBindType {
        TX,
        RX,
        TRX;

    }
}

