/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class SchedulerEventInfo
extends SearchTextBasedWithAdditionalInfo<SchedulerEventId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 2807343040519549363L;
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Customer Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @ApiModelProperty(position=5, value="JSON object with Originator Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private EntityId originatorId;
    @NoXss
    @Length(fieldName="name")
    @ApiModelProperty(position=6, value="scheduler event name", example="Weekly Dashboard Report")
    private String name;
    @ApiModelProperty(position=7, value="scheduler event type", example="generateReport")
    @NoXss
    @Length(fieldName="type")
    private String type;
    @ApiModelProperty(position=8, value="a JSON value with schedule time configuration", dataType="com.fasterxml.jackson.databind.JsonNode")
    private transient JsonNode schedule;
    @JsonIgnore
    private byte[] scheduleBytes;

    public SchedulerEventInfo() {
    }

    public SchedulerEventInfo(SchedulerEventId id) {
        super(id);
    }

    public SchedulerEventInfo(SchedulerEventInfo schedulerEventInfo) {
        super(schedulerEventInfo);
        this.tenantId = schedulerEventInfo.getTenantId();
        this.customerId = schedulerEventInfo.getCustomerId();
        this.originatorId = schedulerEventInfo.getOriginatorId();
        this.name = schedulerEventInfo.getName();
        this.type = schedulerEventInfo.getType();
        this.setSchedule(schedulerEventInfo.getSchedule());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the scheduler event Id. Specify this field to update the scheduler event. Referencing non-existing scheduler event Id will cause error. Omit this field to create new scheduler event")
    public SchedulerEventId getId() {
        return (SchedulerEventId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the scheduler event creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=10, value="Additional parameters of the scheduler event", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @ApiModelProperty(position=5, value="JSON object with Customer or Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    public JsonNode getSchedule() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.schedule, () -> this.scheduleBytes);
    }

    public void setSchedule(JsonNode data) {
        SchedulerEventInfo.setJson(data, json -> {
            this.schedule = json;
        }, bytes -> {
            this.scheduleBytes = bytes;
        });
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.SCHEDULER_EVENT;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public EntityId getOriginatorId() {
        return this.originatorId;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getScheduleBytes() {
        return this.scheduleBytes;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setOriginatorId(EntityId originatorId) {
        this.originatorId = originatorId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setScheduleBytes(byte[] scheduleBytes) {
        this.scheduleBytes = scheduleBytes;
    }

    @Override
    public String toString() {
        return "SchedulerEventInfo(super=" + super.toString() + ", tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", originatorId=" + this.getOriginatorId() + ", name=" + this.getName() + ", type=" + this.getType() + ", schedule=" + this.getSchedule() + ", scheduleBytes=" + Arrays.toString(this.getScheduleBytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerEventInfo)) {
            return false;
        }
        SchedulerEventInfo other = (SchedulerEventInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        EntityId this$originatorId = this.getOriginatorId();
        EntityId other$originatorId = other.getOriginatorId();
        if (this$originatorId == null ? other$originatorId != null : !this$originatorId.equals(other$originatorId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return Arrays.equals(this.getScheduleBytes(), other.getScheduleBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulerEventInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        EntityId $originatorId = this.getOriginatorId();
        result = result * 59 + ($originatorId == null ? 43 : $originatorId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.hashCode(this.getScheduleBytes());
        return result;
    }
}

