/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class RuleNode
extends SearchTextBasedWithAdditionalInfo<RuleNodeId>
implements HasName {
    private static final Logger log = LoggerFactory.getLogger(RuleNode.class);
    private static final long serialVersionUID = -5656679015121235465L;
    @ApiModelProperty(position=3, value="JSON object with the Rule Chain Id. ", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private RuleChainId ruleChainId;
    @Length(fieldName="type")
    @ApiModelProperty(position=4, value="Full Java Class Name of the rule node implementation. ", example="com.mycompany.iot.rule.engine.ProcessingNode")
    private String type;
    @NoXss
    @Length(fieldName="name")
    @ApiModelProperty(position=5, value="User defined name of the rule node. Used on UI and for logging. ", example="Process sensor reading")
    private String name;
    @ApiModelProperty(position=6, value="Enable/disable debug. ", example="false")
    private boolean debugMode;
    @ApiModelProperty(position=7, value="Enable/disable singleton mode. ", example="false")
    private boolean singletonMode;
    @ApiModelProperty(position=8, value="JSON with the rule node configuration. Structure depends on the rule node implementation.", dataType="com.fasterxml.jackson.databind.JsonNode")
    private transient JsonNode configuration;
    @JsonIgnore
    private byte[] configurationBytes;
    private RuleNodeId externalId;

    public RuleNode() {
    }

    public RuleNode(RuleNodeId id) {
        super(id);
    }

    public RuleNode(RuleNode ruleNode) {
        super(ruleNode);
        this.ruleChainId = ruleNode.getRuleChainId();
        this.type = ruleNode.getType();
        this.name = ruleNode.getName();
        this.debugMode = ruleNode.isDebugMode();
        this.singletonMode = ruleNode.isSingletonMode();
        this.setConfiguration(ruleNode.getConfiguration());
        this.externalId = ruleNode.getExternalId();
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonNode getConfiguration() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        RuleNode.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Rule Node Id. Specify this field to update the Rule Node. Referencing non-existing Rule Node Id will cause error. Omit this field to create new rule node.")
    public RuleNodeId getId() {
        return (RuleNodeId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the rule node creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=8, value="Additional parameters of the rule node. Contains 'layoutX' and 'layoutY' properties for visualization.", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isSingletonMode() {
        return this.singletonMode;
    }

    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    public RuleNodeId getExternalId() {
        return this.externalId;
    }

    public void setRuleChainId(RuleChainId ruleChainId) {
        this.ruleChainId = ruleChainId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setSingletonMode(boolean singletonMode) {
        this.singletonMode = singletonMode;
    }

    @JsonIgnore
    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    public void setExternalId(RuleNodeId externalId) {
        this.externalId = externalId;
    }

    @Override
    public String toString() {
        return "RuleNode(ruleChainId=" + this.getRuleChainId() + ", type=" + this.getType() + ", name=" + this.getName() + ", debugMode=" + this.isDebugMode() + ", singletonMode=" + this.isSingletonMode() + ", configuration=" + this.getConfiguration() + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ", externalId=" + this.getExternalId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNode)) {
            return false;
        }
        RuleNode other = (RuleNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isSingletonMode() != other.isSingletonMode()) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !((Object)this$ruleChainId).equals(other$ruleChainId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes())) {
            return false;
        }
        RuleNodeId this$externalId = this.getExternalId();
        RuleNodeId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isSingletonMode() ? 79 : 97);
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : ((Object)$ruleChainId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        RuleNodeId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

