/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.rule.NodeConnectionInfo;
import org.thingsboard.server.common.data.rule.RuleChainConnectionInfo;
import org.thingsboard.server.common.data.rule.RuleNode;

@ApiModel
public class RuleChainMetaData {
    @ApiModelProperty(position=1, required=true, value="JSON object with Rule Chain Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private RuleChainId ruleChainId;
    @ApiModelProperty(position=2, required=true, value="Index of the first rule node in the 'nodes' list")
    private Integer firstNodeIndex;
    @ApiModelProperty(position=3, required=true, value="List of rule node JSON objects")
    private List<RuleNode> nodes;
    @ApiModelProperty(position=4, required=true, value="List of JSON objects that represent connections between rule nodes")
    private List<NodeConnectionInfo> connections;
    @ApiModelProperty(position=5, required=true, value="List of JSON objects that represent connections between rule nodes and other rule chains.")
    private List<RuleChainConnectionInfo> ruleChainConnections;

    public void addConnectionInfo(int fromIndex, int toIndex, String type) {
        NodeConnectionInfo connectionInfo = new NodeConnectionInfo();
        connectionInfo.setFromIndex(fromIndex);
        connectionInfo.setToIndex(toIndex);
        connectionInfo.setType(type);
        if (this.connections == null) {
            this.connections = new ArrayList<NodeConnectionInfo>();
        }
        this.connections.add(connectionInfo);
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public Integer getFirstNodeIndex() {
        return this.firstNodeIndex;
    }

    public List<RuleNode> getNodes() {
        return this.nodes;
    }

    public List<NodeConnectionInfo> getConnections() {
        return this.connections;
    }

    public List<RuleChainConnectionInfo> getRuleChainConnections() {
        return this.ruleChainConnections;
    }

    public void setRuleChainId(RuleChainId ruleChainId) {
        this.ruleChainId = ruleChainId;
    }

    public void setFirstNodeIndex(Integer firstNodeIndex) {
        this.firstNodeIndex = firstNodeIndex;
    }

    public void setNodes(List<RuleNode> nodes) {
        this.nodes = nodes;
    }

    public void setConnections(List<NodeConnectionInfo> connections) {
        this.connections = connections;
    }

    public void setRuleChainConnections(List<RuleChainConnectionInfo> ruleChainConnections) {
        this.ruleChainConnections = ruleChainConnections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChainMetaData)) {
            return false;
        }
        RuleChainMetaData other = (RuleChainMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$firstNodeIndex = this.getFirstNodeIndex();
        Integer other$firstNodeIndex = other.getFirstNodeIndex();
        if (this$firstNodeIndex == null ? other$firstNodeIndex != null : !((Object)this$firstNodeIndex).equals(other$firstNodeIndex)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !((Object)this$ruleChainId).equals(other$ruleChainId)) {
            return false;
        }
        List<RuleNode> this$nodes = this.getNodes();
        List<RuleNode> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<NodeConnectionInfo> this$connections = this.getConnections();
        List<NodeConnectionInfo> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        List<RuleChainConnectionInfo> this$ruleChainConnections = this.getRuleChainConnections();
        List<RuleChainConnectionInfo> other$ruleChainConnections = other.getRuleChainConnections();
        return !(this$ruleChainConnections == null ? other$ruleChainConnections != null : !((Object)this$ruleChainConnections).equals(other$ruleChainConnections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleChainMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $firstNodeIndex = this.getFirstNodeIndex();
        result = result * 59 + ($firstNodeIndex == null ? 43 : ((Object)$firstNodeIndex).hashCode());
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : ((Object)$ruleChainId).hashCode());
        List<RuleNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<NodeConnectionInfo> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        List<RuleChainConnectionInfo> $ruleChainConnections = this.getRuleChainConnections();
        result = result * 59 + ($ruleChainConnections == null ? 43 : ((Object)$ruleChainConnections).hashCode());
        return result;
    }

    public String toString() {
        return "RuleChainMetaData(ruleChainId=" + this.getRuleChainId() + ", firstNodeIndex=" + this.getFirstNodeIndex() + ", nodes=" + this.getNodes() + ", connections=" + this.getConnections() + ", ruleChainConnections=" + this.getRuleChainConnections() + ")";
    }
}

