/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.role;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Role
extends SearchTextBasedWithAdditionalInfo<RoleId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId,
ExportableEntity<RoleId> {
    private static final long serialVersionUID = 5582010124562018986L;
    public static final String ROLE_TENANT_ADMIN_NAME = "Tenant Administrator";
    public static final String ROLE_TENANT_USER_NAME = "Tenant User";
    public static final String ROLE_CUSTOMER_ADMIN_NAME = "Customer Administrator";
    public static final String ROLE_CUSTOMER_USER_NAME = "Customer User";
    public static final String ROLE_PUBLIC_USER_NAME = "Public User";
    public static final String ROLE_PUBLIC_USER_ENTITY_GROUP_NAME = "Entity Group Public User";
    public static final String ROLE_READ_ONLY_ENTITY_GROUP_NAME = "Entity Group Read-only User";
    public static final String ROLE_WRITE_ENTITY_GROUP_NAME = "Entity Group Write User";
    @ApiModelProperty(position=3, required=true, value="JSON object with Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Customer Id. ", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    @ApiModelProperty(position=6, required=true, value="Role Name", example="Read-Only")
    private String name;
    @ApiModelProperty(position=7, required=true, value="Type of the role: generic or group", example="GROUP")
    private RoleType type;
    @ApiModelProperty(position=8, value="JSON object with the set of permissions. Structure is specific for role type", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private transient JsonNode permissions;
    @JsonIgnore
    private byte[] permissionsBytes;
    private RoleId externalId;

    public Role() {
    }

    public Role(RoleId id) {
        super(id);
    }

    public Role(Role role) {
        super(role);
        this.setPermissions(role.getPermissions());
        this.externalId = role.getExternalId();
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @ApiModelProperty(position=5, value="JSON object with Customer or Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ROLE;
    }

    public JsonNode getPermissions() {
        return Role.getJson(() -> this.permissions, () -> this.permissionsBytes);
    }

    public void setPermissions(JsonNode permissions) {
        Role.setJson(permissions, json -> {
            this.permissions = json;
        }, bytes -> {
            this.permissionsBytes = bytes;
        });
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Role Id. Specify this field to update the Role. Referencing non-existing Role Id will cause error. Omit this field to create new Role.")
    public RoleId getId() {
        return (RoleId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the role creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=13, value="Additional parameters of the role", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RoleType getType() {
        return this.type;
    }

    public byte[] getPermissionsBytes() {
        return this.permissionsBytes;
    }

    @Override
    public RoleId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(RoleType type) {
        this.type = type;
    }

    @JsonIgnore
    public void setPermissionsBytes(byte[] permissionsBytes) {
        this.permissionsBytes = permissionsBytes;
    }

    @Override
    public void setExternalId(RoleId externalId) {
        this.externalId = externalId;
    }

    @Override
    public String toString() {
        return "Role(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", name=" + this.getName() + ", type=" + this.getType() + ", permissions=" + this.getPermissions() + ", permissionsBytes=" + Arrays.toString(this.getPermissionsBytes()) + ", externalId=" + this.getExternalId() + ")";
    }

    @ConstructorProperties(value={"tenantId", "customerId", "name", "type", "permissions", "permissionsBytes", "externalId"})
    public Role(TenantId tenantId, CustomerId customerId, String name, RoleType type, JsonNode permissions, byte[] permissionsBytes, RoleId externalId) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.type = type;
        this.permissions = permissions;
        this.permissionsBytes = permissionsBytes;
        this.externalId = externalId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RoleType this$type = this.getType();
        RoleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getPermissionsBytes(), other.getPermissionsBytes())) {
            return false;
        }
        RoleId this$externalId = this.getExternalId();
        RoleId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RoleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPermissionsBytes());
        RoleId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

