/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.queue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Queue
extends SearchTextBasedWithAdditionalInfo<QueueId>
implements HasName,
TenantEntity {
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    @NoXss
    @Length(fieldName="topic")
    private String topic;
    private int pollInterval;
    private int partitions;
    private boolean consumerPerPartition;
    private long packProcessingTimeout;
    private SubmitStrategy submitStrategy;
    private ProcessingStrategy processingStrategy;

    public Queue() {
    }

    public Queue(QueueId id) {
        super(id);
    }

    public Queue(TenantId tenantId, TenantProfileQueueConfiguration queueConfiguration) {
        this.tenantId = tenantId;
        this.name = queueConfiguration.getName();
        this.topic = queueConfiguration.getTopic();
        this.pollInterval = queueConfiguration.getPollInterval();
        this.partitions = queueConfiguration.getPartitions();
        this.consumerPerPartition = queueConfiguration.isConsumerPerPartition();
        this.packProcessingTimeout = queueConfiguration.getPackProcessingTimeout();
        this.submitStrategy = queueConfiguration.getSubmitStrategy();
        this.processingStrategy = queueConfiguration.getProcessingStrategy();
        this.setAdditionalInfo(queueConfiguration.getAdditionalInfo());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.QUEUE;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public boolean isConsumerPerPartition() {
        return this.consumerPerPartition;
    }

    public long getPackProcessingTimeout() {
        return this.packProcessingTimeout;
    }

    public SubmitStrategy getSubmitStrategy() {
        return this.submitStrategy;
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public void setConsumerPerPartition(boolean consumerPerPartition) {
        this.consumerPerPartition = consumerPerPartition;
    }

    public void setPackProcessingTimeout(long packProcessingTimeout) {
        this.packProcessingTimeout = packProcessingTimeout;
    }

    public void setSubmitStrategy(SubmitStrategy submitStrategy) {
        this.submitStrategy = submitStrategy;
    }

    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPollInterval() != other.getPollInterval()) {
            return false;
        }
        if (this.getPartitions() != other.getPartitions()) {
            return false;
        }
        if (this.isConsumerPerPartition() != other.isConsumerPerPartition()) {
            return false;
        }
        if (this.getPackProcessingTimeout() != other.getPackProcessingTimeout()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        SubmitStrategy this$submitStrategy = this.getSubmitStrategy();
        SubmitStrategy other$submitStrategy = other.getSubmitStrategy();
        if (this$submitStrategy == null ? other$submitStrategy != null : !((Object)this$submitStrategy).equals(other$submitStrategy)) {
            return false;
        }
        ProcessingStrategy this$processingStrategy = this.getProcessingStrategy();
        ProcessingStrategy other$processingStrategy = other.getProcessingStrategy();
        return !(this$processingStrategy == null ? other$processingStrategy != null : !((Object)this$processingStrategy).equals(other$processingStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Queue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPollInterval();
        result = result * 59 + this.getPartitions();
        result = result * 59 + (this.isConsumerPerPartition() ? 79 : 97);
        long $packProcessingTimeout = this.getPackProcessingTimeout();
        result = result * 59 + (int)($packProcessingTimeout >>> 32 ^ $packProcessingTimeout);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        SubmitStrategy $submitStrategy = this.getSubmitStrategy();
        result = result * 59 + ($submitStrategy == null ? 43 : ((Object)$submitStrategy).hashCode());
        ProcessingStrategy $processingStrategy = this.getProcessingStrategy();
        result = result * 59 + ($processingStrategy == null ? 43 : ((Object)$processingStrategy).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Queue(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", topic=" + this.getTopic() + ", pollInterval=" + this.getPollInterval() + ", partitions=" + this.getPartitions() + ", consumerPerPartition=" + this.isConsumerPerPartition() + ", packProcessingTimeout=" + this.getPackProcessingTimeout() + ", submitStrategy=" + this.getSubmitStrategy() + ", processingStrategy=" + this.getProcessingStrategy() + ")";
    }
}

