/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.ComponentDescriptorId;
import org.thingsboard.server.common.data.plugin.ComponentClusteringMode;
import org.thingsboard.server.common.data.plugin.ComponentScope;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.validation.Length;

@ApiModel
public class ComponentDescriptor
extends SearchTextBased<ComponentDescriptorId> {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(position=3, value="Type of the Rule Node", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private ComponentType type;
    @ApiModelProperty(position=4, value="Scope of the Rule Node. Always set to 'TENANT', since no rule chains on the 'SYSTEM' level yet.", accessMode=ApiModelProperty.AccessMode.READ_ONLY, allowableValues="TENANT", example="TENANT")
    private ComponentScope scope;
    @ApiModelProperty(position=5, value="Clustering mode of the RuleNode. This mode represents the ability to start Rule Node in multiple microservices.", accessMode=ApiModelProperty.AccessMode.READ_ONLY, allowableValues="USER_PREFERENCE, ENABLED, SINGLETON", example="ENABLED")
    private ComponentClusteringMode clusteringMode;
    @Length(fieldName="name")
    @ApiModelProperty(position=6, value="Name of the Rule Node. Taken from the @RuleNode annotation.", accessMode=ApiModelProperty.AccessMode.READ_ONLY, example="Custom Rule Node")
    private String name;
    @ApiModelProperty(position=7, value="Full name of the Java class that implements the Rule Engine Node interface.", accessMode=ApiModelProperty.AccessMode.READ_ONLY, example="com.mycompany.CustomRuleNode")
    private String clazz;
    @ApiModelProperty(position=8, value="Complex JSON object that represents the Rule Node configuration.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private transient JsonNode configurationDescriptor;
    @Length(fieldName="actions")
    @ApiModelProperty(position=9, value="Rule Node Actions. Deprecated. Always null.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String actions;

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(ComponentDescriptorId id) {
        super(id);
    }

    public ComponentDescriptor(ComponentDescriptor plugin) {
        super(plugin);
        this.type = plugin.getType();
        this.scope = plugin.getScope();
        this.name = plugin.getName();
        this.clazz = plugin.getClazz();
        this.configurationDescriptor = plugin.getConfigurationDescriptor();
        this.actions = plugin.getActions();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the descriptor Id. Specify existing descriptor id to update the descriptor. Referencing non-existing descriptor Id will cause error. Omit this field to create new descriptor.")
    public ComponentDescriptorId getId() {
        return (ComponentDescriptorId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the descriptor creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public String getSearchText() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDescriptor that = (ComponentDescriptor)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.configurationDescriptor != null ? !this.configurationDescriptor.equals((Object)that.configurationDescriptor) : that.configurationDescriptor != null) {
            return false;
        }
        return this.clazz != null ? this.clazz.equals(that.clazz) : that.clazz == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ComponentDescriptor(type=" + this.getType() + ", scope=" + this.getScope() + ", clusteringMode=" + this.getClusteringMode() + ", name=" + this.getName() + ", clazz=" + this.getClazz() + ", configurationDescriptor=" + this.getConfigurationDescriptor() + ", actions=" + this.getActions() + ")";
    }

    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public ComponentScope getScope() {
        return this.scope;
    }

    public void setScope(ComponentScope scope) {
        this.scope = scope;
    }

    public ComponentClusteringMode getClusteringMode() {
        return this.clusteringMode;
    }

    public void setClusteringMode(ComponentClusteringMode clusteringMode) {
        this.clusteringMode = clusteringMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public JsonNode getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void setConfigurationDescriptor(JsonNode configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }
}

