/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;

@ApiModel
public class ShareGroupRequest {
    @ApiModelProperty(position=2, value="In case 'allUserGroup' is set to true, this property specifies the owner of the user group 'All'. Either Tenant or Customer Id.")
    private final EntityId ownerId;
    @ApiModelProperty(position=1, required=true, value="Indicate that the group should be shared with user group 'All' that belongs to Tenant or Customer (see 'ownerId' property description).", name="")
    private final boolean allUserGroup;
    @ApiModelProperty(position=3, value="In case 'allUserGroup' is set to false, this property specifies the specific user group that the entity group should be shared with.")
    private final EntityGroupId userGroupId;
    @ApiModelProperty(position=4, value="Used if 'roleIds' property is not present. if the value is 'true', creates role with read-only permissions. If the value is 'false', creates role with write permissions.")
    private final boolean readElseWrite;
    @ApiModelProperty(position=4, value="List of group role Ids that should be used to share the entity group with the user group. If not set, the platform will create new role (see 'readElseWrite' property description)")
    private final List<RoleId> roleIds;

    @ConstructorProperties(value={"ownerId", "allUserGroup", "userGroupId", "readElseWrite", "roleIds"})
    public ShareGroupRequest(EntityId ownerId, boolean allUserGroup, EntityGroupId userGroupId, boolean readElseWrite, List<RoleId> roleIds) {
        this.ownerId = ownerId;
        this.allUserGroup = allUserGroup;
        this.userGroupId = userGroupId;
        this.readElseWrite = readElseWrite;
        this.roleIds = roleIds;
    }

    public EntityId getOwnerId() {
        return this.ownerId;
    }

    public boolean isAllUserGroup() {
        return this.allUserGroup;
    }

    public EntityGroupId getUserGroupId() {
        return this.userGroupId;
    }

    public boolean isReadElseWrite() {
        return this.readElseWrite;
    }

    public List<RoleId> getRoleIds() {
        return this.roleIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShareGroupRequest)) {
            return false;
        }
        ShareGroupRequest other = (ShareGroupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllUserGroup() != other.isAllUserGroup()) {
            return false;
        }
        if (this.isReadElseWrite() != other.isReadElseWrite()) {
            return false;
        }
        EntityId this$ownerId = this.getOwnerId();
        EntityId other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        EntityGroupId this$userGroupId = this.getUserGroupId();
        EntityGroupId other$userGroupId = other.getUserGroupId();
        if (this$userGroupId == null ? other$userGroupId != null : !((Object)this$userGroupId).equals(other$userGroupId)) {
            return false;
        }
        List<RoleId> this$roleIds = this.getRoleIds();
        List<RoleId> other$roleIds = other.getRoleIds();
        return !(this$roleIds == null ? other$roleIds != null : !((Object)this$roleIds).equals(other$roleIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShareGroupRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllUserGroup() ? 79 : 97);
        result = result * 59 + (this.isReadElseWrite() ? 79 : 97);
        EntityId $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        EntityGroupId $userGroupId = this.getUserGroupId();
        result = result * 59 + ($userGroupId == null ? 43 : ((Object)$userGroupId).hashCode());
        List<RoleId> $roleIds = this.getRoleIds();
        result = result * 59 + ($roleIds == null ? 43 : ((Object)$roleIds).hashCode());
        return result;
    }

    public String toString() {
        return "ShareGroupRequest(ownerId=" + this.getOwnerId() + ", allUserGroup=" + this.isAllUserGroup() + ", userGroupId=" + this.getUserGroupId() + ", readElseWrite=" + this.isReadElseWrite() + ", roleIds=" + this.getRoleIds() + ")";
    }
}

