/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;

public class GroupPermission
extends BaseData<GroupPermissionId>
implements HasName,
TenantEntity {
    private static final long serialVersionUID = 5582010124562018986L;
    public static final Map<Resource, List<Operation>> ALL_PERMISSIONS = new HashMap<Resource, List<Operation>>();
    public static final List<Operation> READ_ONLY_GROUP_PERMISSIONS;
    public static final List<Operation> WRITE_GROUP_PERMISSIONS;
    public static final Map<Resource, List<Operation>> READ_ONLY_USER_PERMISSIONS;
    public static final Map<Resource, List<Operation>> PUBLIC_USER_PERMISSIONS;
    public static final List<Operation> PUBLIC_USER_ENTITY_GROUP_PERMISSIONS;
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with the User Group Id. Represent user group that will have permissions to perform operations against corresponding Entity Group.")
    private EntityGroupId userGroupId;
    @ApiModelProperty(position=5, value="JSON object with the Role Id. Represent set of permissions.")
    private RoleId roleId;
    @ApiModelProperty(position=6, value="JSON object with the Entity Group Id. Represent entity (device, asset, etc.) group.")
    private EntityGroupId entityGroupId;
    @ApiModelProperty(position=7, value="Type of the entities in the group: DEVICE, ASSET, CUSTOMER, etc.")
    private EntityType entityGroupType;
    @ApiModelProperty(position=8, value="Public or Private permissions. Private by default.", example="false")
    private boolean isPublic;

    public GroupPermission() {
    }

    public GroupPermission(GroupPermissionId id) {
        super(id);
    }

    public GroupPermission(GroupPermission groupPermission) {
        super(groupPermission);
        this.tenantId = groupPermission.getTenantId();
        this.userGroupId = groupPermission.getUserGroupId();
        this.roleId = groupPermission.getRoleId();
        this.entityGroupId = groupPermission.getEntityGroupId();
        this.entityGroupType = groupPermission.getEntityGroupType();
        this.isPublic = groupPermission.isPublic();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with the Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @ApiModelProperty(position=8, value="Name of the Group Permissions. Auto-generated", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        if (this.entityGroupId != null && this.entityGroupType != null) {
            return String.format("GROUP_[%s]_[%s]_[%s]_[%s]", this.userGroupId != null ? this.userGroupId.toString() : "", this.roleId.toString(), this.entityGroupId.toString(), this.entityGroupType.name());
        }
        return String.format("GENERIC_[%s]_[%s]", this.userGroupId != null ? this.userGroupId.toString() : "", this.roleId.toString());
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.GROUP_PERMISSION;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Group Permission Id. Specify this field to update the Group Permission. Referencing non-existing Group Permission Id will cause error. Omit this field to create new Group Permission.")
    public GroupPermissionId getId() {
        return (GroupPermissionId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the group permission creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    public EntityGroupId getUserGroupId() {
        return this.userGroupId;
    }

    public RoleId getRoleId() {
        return this.roleId;
    }

    public EntityGroupId getEntityGroupId() {
        return this.entityGroupId;
    }

    public EntityType getEntityGroupType() {
        return this.entityGroupType;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setUserGroupId(EntityGroupId userGroupId) {
        this.userGroupId = userGroupId;
    }

    public void setRoleId(RoleId roleId) {
        this.roleId = roleId;
    }

    public void setEntityGroupId(EntityGroupId entityGroupId) {
        this.entityGroupId = entityGroupId;
    }

    public void setEntityGroupType(EntityType entityGroupType) {
        this.entityGroupType = entityGroupType;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public String toString() {
        return "GroupPermission(tenantId=" + this.getTenantId() + ", userGroupId=" + this.getUserGroupId() + ", roleId=" + this.getRoleId() + ", entityGroupId=" + this.getEntityGroupId() + ", entityGroupType=" + this.getEntityGroupType() + ", isPublic=" + this.isPublic() + ")";
    }

    @ConstructorProperties(value={"tenantId", "userGroupId", "roleId", "entityGroupId", "entityGroupType", "isPublic"})
    public GroupPermission(TenantId tenantId, EntityGroupId userGroupId, RoleId roleId, EntityGroupId entityGroupId, EntityType entityGroupType, boolean isPublic) {
        this.tenantId = tenantId;
        this.userGroupId = userGroupId;
        this.roleId = roleId;
        this.entityGroupId = entityGroupId;
        this.entityGroupType = entityGroupType;
        this.isPublic = isPublic;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupPermission)) {
            return false;
        }
        GroupPermission other = (GroupPermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityGroupId this$userGroupId = this.getUserGroupId();
        EntityGroupId other$userGroupId = other.getUserGroupId();
        if (this$userGroupId == null ? other$userGroupId != null : !((Object)this$userGroupId).equals(other$userGroupId)) {
            return false;
        }
        RoleId this$roleId = this.getRoleId();
        RoleId other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !((Object)this$roleId).equals(other$roleId)) {
            return false;
        }
        EntityGroupId this$entityGroupId = this.getEntityGroupId();
        EntityGroupId other$entityGroupId = other.getEntityGroupId();
        if (this$entityGroupId == null ? other$entityGroupId != null : !((Object)this$entityGroupId).equals(other$entityGroupId)) {
            return false;
        }
        EntityType this$entityGroupType = this.getEntityGroupType();
        EntityType other$entityGroupType = other.getEntityGroupType();
        return !(this$entityGroupType == null ? other$entityGroupType != null : !((Object)((Object)this$entityGroupType)).equals((Object)other$entityGroupType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupPermission;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPublic() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityGroupId $userGroupId = this.getUserGroupId();
        result = result * 59 + ($userGroupId == null ? 43 : ((Object)$userGroupId).hashCode());
        RoleId $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : ((Object)$roleId).hashCode());
        EntityGroupId $entityGroupId = this.getEntityGroupId();
        result = result * 59 + ($entityGroupId == null ? 43 : ((Object)$entityGroupId).hashCode());
        EntityType $entityGroupType = this.getEntityGroupType();
        result = result * 59 + ($entityGroupType == null ? 43 : ((Object)((Object)$entityGroupType)).hashCode());
        return result;
    }

    static {
        ALL_PERMISSIONS.put(Resource.ALL, Collections.singletonList(Operation.ALL));
        READ_ONLY_GROUP_PERMISSIONS = Arrays.asList(Operation.READ, Operation.RPC_CALL, Operation.READ_CREDENTIALS, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY);
        WRITE_GROUP_PERMISSIONS = Collections.singletonList(Operation.ALL);
        READ_ONLY_USER_PERMISSIONS = new HashMap<Resource, List<Operation>>();
        READ_ONLY_USER_PERMISSIONS.put(Resource.ALL, READ_ONLY_GROUP_PERMISSIONS);
        READ_ONLY_USER_PERMISSIONS.put(Resource.PROFILE, Arrays.asList(Operation.ALL));
        PUBLIC_USER_PERMISSIONS = new HashMap<Resource, List<Operation>>();
        PUBLIC_USER_PERMISSIONS.put(Resource.DASHBOARD, Arrays.asList(Operation.READ));
        PUBLIC_USER_PERMISSIONS.put(Resource.WIDGETS_BUNDLE, Arrays.asList(Operation.READ));
        PUBLIC_USER_PERMISSIONS.put(Resource.WIDGET_TYPE, Arrays.asList(Operation.READ));
        PUBLIC_USER_PERMISSIONS.put(Resource.ALARM, Arrays.asList(Operation.READ));
        PUBLIC_USER_ENTITY_GROUP_PERMISSIONS = Arrays.asList(Operation.READ, Operation.RPC_CALL, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY);
    }
}

