/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.oauth2.OAuth2ParamsInfo;

@ApiModel
public class OAuth2Info {
    @ApiModelProperty(value="Whether OAuth2 settings are enabled or not")
    private boolean enabled;
    @ApiModelProperty(value="List of configured OAuth2 clients. Cannot contain null values", required=true)
    private List<OAuth2ParamsInfo> oauth2ParamsInfos;

    public static OAuth2InfoBuilder builder() {
        return new OAuth2InfoBuilder();
    }

    public OAuth2InfoBuilder toBuilder() {
        return new OAuth2InfoBuilder().enabled(this.enabled).oauth2ParamsInfos(this.oauth2ParamsInfos);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Info)) {
            return false;
        }
        OAuth2Info other = (OAuth2Info)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<OAuth2ParamsInfo> this$oauth2ParamsInfos = this.getOauth2ParamsInfos();
        List<OAuth2ParamsInfo> other$oauth2ParamsInfos = other.getOauth2ParamsInfos();
        return !(this$oauth2ParamsInfos == null ? other$oauth2ParamsInfos != null : !((Object)this$oauth2ParamsInfos).equals(other$oauth2ParamsInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2Info;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<OAuth2ParamsInfo> $oauth2ParamsInfos = this.getOauth2ParamsInfos();
        result = result * 59 + ($oauth2ParamsInfos == null ? 43 : ((Object)$oauth2ParamsInfos).hashCode());
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<OAuth2ParamsInfo> getOauth2ParamsInfos() {
        return this.oauth2ParamsInfos;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOauth2ParamsInfos(List<OAuth2ParamsInfo> oauth2ParamsInfos) {
        this.oauth2ParamsInfos = oauth2ParamsInfos;
    }

    public String toString() {
        return "OAuth2Info(enabled=" + this.isEnabled() + ", oauth2ParamsInfos=" + this.getOauth2ParamsInfos() + ")";
    }

    public OAuth2Info() {
    }

    @ConstructorProperties(value={"enabled", "oauth2ParamsInfos"})
    public OAuth2Info(boolean enabled, List<OAuth2ParamsInfo> oauth2ParamsInfos) {
        this.enabled = enabled;
        this.oauth2ParamsInfos = oauth2ParamsInfos;
    }

    public static class OAuth2InfoBuilder {
        private boolean enabled;
        private List<OAuth2ParamsInfo> oauth2ParamsInfos;

        OAuth2InfoBuilder() {
        }

        public OAuth2InfoBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OAuth2InfoBuilder oauth2ParamsInfos(List<OAuth2ParamsInfo> oauth2ParamsInfos) {
            this.oauth2ParamsInfos = oauth2ParamsInfos;
            return this;
        }

        public OAuth2Info build() {
            return new OAuth2Info(this.enabled, this.oauth2ParamsInfos);
        }

        public String toString() {
            return "OAuth2Info.OAuth2InfoBuilder(enabled=" + this.enabled + ", oauth2ParamsInfos=" + this.oauth2ParamsInfos + ")";
        }
    }
}

