/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;

@ApiModel
public class OAuth2ClientInfo {
    @ApiModelProperty(value="OAuth2 client name", example="GitHub")
    private String name;
    @ApiModelProperty(value="Name of the icon, displayed on OAuth2 log in button", example="github-logo")
    private String icon;
    @ApiModelProperty(value="URI for OAuth2 log in. On HTTP GET request to this URI, it redirects to the OAuth2 provider page", example="/oauth2/authorization/8352f191-2b4d-11ec-9ed1-cbf57c026ecc")
    private String url;

    public OAuth2ClientInfo(OAuth2ClientInfo oauth2ClientInfo) {
        this.name = oauth2ClientInfo.getName();
        this.icon = oauth2ClientInfo.getIcon();
        this.url = oauth2ClientInfo.getUrl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ClientInfo)) {
            return false;
        }
        OAuth2ClientInfo other = (OAuth2ClientInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2ClientInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "OAuth2ClientInfo(name=" + this.getName() + ", icon=" + this.getIcon() + ", url=" + this.getUrl() + ")";
    }

    public OAuth2ClientInfo() {
    }

    @ConstructorProperties(value={"name", "icon", "url"})
    public OAuth2ClientInfo(String name, String icon, String url) {
        this.name = name;
        this.icon = icon;
        this.url = url;
    }
}

