/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.HasSubject;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class EmailDeliveryMethodNotificationTemplate
extends DeliveryMethodNotificationTemplate
implements HasSubject {
    @NoXss(fieldName="email subject")
    @Length(fieldName="email subject", max=250, message="cannot be longer than 250 chars")
    @NotEmpty
    private String subject;

    public EmailDeliveryMethodNotificationTemplate(EmailDeliveryMethodNotificationTemplate other) {
        super(other);
        this.subject = other.subject;
    }

    @Override
    public NotificationDeliveryMethod getMethod() {
        return NotificationDeliveryMethod.EMAIL;
    }

    @Override
    public EmailDeliveryMethodNotificationTemplate copy() {
        return new EmailDeliveryMethodNotificationTemplate(this);
    }

    @Override
    public boolean containsAny(String ... params) {
        return super.containsAny(params) || StringUtils.containsAny((CharSequence)this.subject, (CharSequence[])params);
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailDeliveryMethodNotificationTemplate() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailDeliveryMethodNotificationTemplate)) {
            return false;
        }
        EmailDeliveryMethodNotificationTemplate other = (EmailDeliveryMethodNotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        return !(this$subject == null ? other$subject != null : !this$subject.equals(other$subject));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmailDeliveryMethodNotificationTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EmailDeliveryMethodNotificationTemplate(super=" + super.toString() + ", subject=" + this.getSubject() + ")";
    }
}

