/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.EmailDeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.SlackDeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.SmsDeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.WebDeliveryMethodNotificationTemplate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="method")
@JsonSubTypes(value={@JsonSubTypes.Type(name="WEB", value=WebDeliveryMethodNotificationTemplate.class), @JsonSubTypes.Type(name="EMAIL", value=EmailDeliveryMethodNotificationTemplate.class), @JsonSubTypes.Type(name="SMS", value=SmsDeliveryMethodNotificationTemplate.class), @JsonSubTypes.Type(name="SLACK", value=SlackDeliveryMethodNotificationTemplate.class)})
public abstract class DeliveryMethodNotificationTemplate {
    private boolean enabled;
    @NotEmpty
    private String body;

    public DeliveryMethodNotificationTemplate(DeliveryMethodNotificationTemplate other) {
        this.enabled = other.enabled;
        this.body = other.body;
    }

    @JsonIgnore
    public abstract NotificationDeliveryMethod getMethod();

    @JsonIgnore
    public abstract DeliveryMethodNotificationTemplate copy();

    public boolean containsAny(String ... params) {
        return StringUtils.containsAny((CharSequence)this.body, (CharSequence[])params);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBody() {
        return this.body;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeliveryMethodNotificationTemplate)) {
            return false;
        }
        DeliveryMethodNotificationTemplate other = (DeliveryMethodNotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeliveryMethodNotificationTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "DeliveryMethodNotificationTemplate(enabled=" + this.isEnabled() + ", body=" + this.getBody() + ")";
    }

    public DeliveryMethodNotificationTemplate() {
    }
}

