/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleConfig;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class NotificationRule
extends BaseData<NotificationRuleId>
implements HasName,
TenantEntity,
Serializable {
    private TenantId tenantId;
    @NotBlank
    @NoXss
    @Length(max=255, message="cannot be longer than 255 chars")
    private String name;
    @NotNull
    private NotificationTemplateId templateId;
    @NotNull
    private NotificationRuleTriggerType triggerType;
    @NotNull
    @Valid
    private NotificationRuleTriggerConfig triggerConfig;
    @NotNull
    @Valid
    private NotificationRuleRecipientsConfig recipientsConfig;
    private NotificationRuleConfig additionalConfig;

    public NotificationRule(NotificationRule other) {
        super(other);
        this.tenantId = other.tenantId;
        this.name = other.name;
        this.templateId = other.templateId;
        this.triggerType = other.triggerType;
        this.triggerConfig = other.triggerConfig;
        this.recipientsConfig = other.recipientsConfig;
        this.additionalConfig = other.additionalConfig;
    }

    @JsonIgnore
    @AssertTrue(message="trigger type not matching")
    public @AssertTrue(message="trigger type not matching") boolean isValid() {
        return this.triggerType == this.triggerConfig.getTriggerType() && this.triggerType == this.recipientsConfig.getTriggerType();
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.NOTIFICATION_RULE;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NotificationTemplateId getTemplateId() {
        return this.templateId;
    }

    public NotificationRuleTriggerType getTriggerType() {
        return this.triggerType;
    }

    public NotificationRuleTriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public NotificationRuleRecipientsConfig getRecipientsConfig() {
        return this.recipientsConfig;
    }

    public NotificationRuleConfig getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplateId(NotificationTemplateId templateId) {
        this.templateId = templateId;
    }

    public void setTriggerType(NotificationRuleTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setTriggerConfig(NotificationRuleTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public void setRecipientsConfig(NotificationRuleRecipientsConfig recipientsConfig) {
        this.recipientsConfig = recipientsConfig;
    }

    public void setAdditionalConfig(NotificationRuleConfig additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Override
    public String toString() {
        return "NotificationRule(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", templateId=" + this.getTemplateId() + ", triggerType=" + this.getTriggerType() + ", triggerConfig=" + this.getTriggerConfig() + ", recipientsConfig=" + this.getRecipientsConfig() + ", additionalConfig=" + this.getAdditionalConfig() + ")";
    }

    public NotificationRule() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRule)) {
            return false;
        }
        NotificationRule other = (NotificationRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationTemplateId this$templateId = this.getTemplateId();
        NotificationTemplateId other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        NotificationRuleTriggerType this$triggerType = this.getTriggerType();
        NotificationRuleTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        NotificationRuleTriggerConfig this$triggerConfig = this.getTriggerConfig();
        NotificationRuleTriggerConfig other$triggerConfig = other.getTriggerConfig();
        if (this$triggerConfig == null ? other$triggerConfig != null : !this$triggerConfig.equals(other$triggerConfig)) {
            return false;
        }
        NotificationRuleRecipientsConfig this$recipientsConfig = this.getRecipientsConfig();
        NotificationRuleRecipientsConfig other$recipientsConfig = other.getRecipientsConfig();
        if (this$recipientsConfig == null ? other$recipientsConfig != null : !((Object)this$recipientsConfig).equals(other$recipientsConfig)) {
            return false;
        }
        NotificationRuleConfig this$additionalConfig = this.getAdditionalConfig();
        NotificationRuleConfig other$additionalConfig = other.getAdditionalConfig();
        return !(this$additionalConfig == null ? other$additionalConfig != null : !((Object)this$additionalConfig).equals(other$additionalConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationRule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationTemplateId $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        NotificationRuleTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        NotificationRuleTriggerConfig $triggerConfig = this.getTriggerConfig();
        result = result * 59 + ($triggerConfig == null ? 43 : $triggerConfig.hashCode());
        NotificationRuleRecipientsConfig $recipientsConfig = this.getRecipientsConfig();
        result = result * 59 + ($recipientsConfig == null ? 43 : ((Object)$recipientsConfig).hashCode());
        NotificationRuleConfig $additionalConfig = this.getAdditionalConfig();
        result = result * 59 + ($additionalConfig == null ? 43 : ((Object)$additionalConfig).hashCode());
        return result;
    }
}

