/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class EntitiesLimitNotificationInfo
implements RuleOriginatedNotificationInfo {
    private EntityType entityType;
    private long currentCount;
    private long limit;
    private int percents;
    private TenantId tenantId;
    private String tenantName;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("entityType", this.entityType.getNormalName(), "currentCount", String.valueOf(this.currentCount), "limit", String.valueOf(this.limit), "percents", String.valueOf(this.percents), "tenantId", this.tenantId.toString(), "tenantName", this.tenantName);
    }

    @Override
    public TenantId getAffectedTenantId() {
        return this.tenantId;
    }

    public static EntitiesLimitNotificationInfoBuilder builder() {
        return new EntitiesLimitNotificationInfoBuilder();
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public long getCurrentCount() {
        return this.currentCount;
    }

    public long getLimit() {
        return this.limit;
    }

    public int getPercents() {
        return this.percents;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setCurrentCount(long currentCount) {
        this.currentCount = currentCount;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setPercents(int percents) {
        this.percents = percents;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesLimitNotificationInfo)) {
            return false;
        }
        EntitiesLimitNotificationInfo other = (EntitiesLimitNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentCount() != other.getCurrentCount()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getPercents() != other.getPercents()) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        return !(this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntitiesLimitNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $currentCount = this.getCurrentCount();
        result = result * 59 + (int)($currentCount >>> 32 ^ $currentCount);
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        result = result * 59 + this.getPercents();
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        return result;
    }

    public String toString() {
        return "EntitiesLimitNotificationInfo(entityType=" + this.getEntityType() + ", currentCount=" + this.getCurrentCount() + ", limit=" + this.getLimit() + ", percents=" + this.getPercents() + ", tenantId=" + this.getTenantId() + ", tenantName=" + this.getTenantName() + ")";
    }

    public EntitiesLimitNotificationInfo() {
    }

    @ConstructorProperties(value={"entityType", "currentCount", "limit", "percents", "tenantId", "tenantName"})
    public EntitiesLimitNotificationInfo(EntityType entityType, long currentCount, long limit, int percents, TenantId tenantId, String tenantName) {
        this.entityType = entityType;
        this.currentCount = currentCount;
        this.limit = limit;
        this.percents = percents;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
    }

    public static class EntitiesLimitNotificationInfoBuilder {
        private EntityType entityType;
        private long currentCount;
        private long limit;
        private int percents;
        private TenantId tenantId;
        private String tenantName;

        EntitiesLimitNotificationInfoBuilder() {
        }

        public EntitiesLimitNotificationInfoBuilder entityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public EntitiesLimitNotificationInfoBuilder currentCount(long currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        public EntitiesLimitNotificationInfoBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public EntitiesLimitNotificationInfoBuilder percents(int percents) {
            this.percents = percents;
            return this;
        }

        public EntitiesLimitNotificationInfoBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EntitiesLimitNotificationInfoBuilder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public EntitiesLimitNotificationInfo build() {
            return new EntitiesLimitNotificationInfo(this.entityType, this.currentCount, this.limit, this.percents, this.tenantId, this.tenantName);
        }

        public String toString() {
            return "EntitiesLimitNotificationInfo.EntitiesLimitNotificationInfoBuilder(entityType=" + this.entityType + ", currentCount=" + this.currentCount + ", limit=" + this.limit + ", percents=" + this.percents + ", tenantId=" + this.tenantId + ", tenantName=" + this.tenantName + ")";
        }
    }
}

