/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class DeviceActivityNotificationInfo
implements RuleOriginatedNotificationInfo {
    private String eventType;
    private UUID deviceId;
    private String deviceName;
    private String deviceLabel;
    private String deviceType;
    private CustomerId deviceCustomerId;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("eventType", this.eventType, "deviceId", this.deviceId.toString(), "deviceName", this.deviceName, "deviceLabel", this.deviceLabel, "deviceType", this.deviceType);
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.deviceCustomerId;
    }

    @Override
    public EntityId getStateEntityId() {
        return new DeviceId(this.deviceId);
    }

    public static DeviceActivityNotificationInfoBuilder builder() {
        return new DeviceActivityNotificationInfoBuilder();
    }

    public String getEventType() {
        return this.eventType;
    }

    public UUID getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceLabel() {
        return this.deviceLabel;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public CustomerId getDeviceCustomerId() {
        return this.deviceCustomerId;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setDeviceId(UUID deviceId) {
        this.deviceId = deviceId;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setDeviceLabel(String deviceLabel) {
        this.deviceLabel = deviceLabel;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceCustomerId(CustomerId deviceCustomerId) {
        this.deviceCustomerId = deviceCustomerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceActivityNotificationInfo)) {
            return false;
        }
        DeviceActivityNotificationInfo other = (DeviceActivityNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        UUID this$deviceId = this.getDeviceId();
        UUID other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !((Object)this$deviceId).equals(other$deviceId)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        String this$deviceLabel = this.getDeviceLabel();
        String other$deviceLabel = other.getDeviceLabel();
        if (this$deviceLabel == null ? other$deviceLabel != null : !this$deviceLabel.equals(other$deviceLabel)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        CustomerId this$deviceCustomerId = this.getDeviceCustomerId();
        CustomerId other$deviceCustomerId = other.getDeviceCustomerId();
        return !(this$deviceCustomerId == null ? other$deviceCustomerId != null : !((Object)this$deviceCustomerId).equals(other$deviceCustomerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceActivityNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        UUID $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : ((Object)$deviceId).hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        String $deviceLabel = this.getDeviceLabel();
        result = result * 59 + ($deviceLabel == null ? 43 : $deviceLabel.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        CustomerId $deviceCustomerId = this.getDeviceCustomerId();
        result = result * 59 + ($deviceCustomerId == null ? 43 : ((Object)$deviceCustomerId).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceActivityNotificationInfo(eventType=" + this.getEventType() + ", deviceId=" + this.getDeviceId() + ", deviceName=" + this.getDeviceName() + ", deviceLabel=" + this.getDeviceLabel() + ", deviceType=" + this.getDeviceType() + ", deviceCustomerId=" + this.getDeviceCustomerId() + ")";
    }

    public DeviceActivityNotificationInfo() {
    }

    @ConstructorProperties(value={"eventType", "deviceId", "deviceName", "deviceLabel", "deviceType", "deviceCustomerId"})
    public DeviceActivityNotificationInfo(String eventType, UUID deviceId, String deviceName, String deviceLabel, String deviceType, CustomerId deviceCustomerId) {
        this.eventType = eventType;
        this.deviceId = deviceId;
        this.deviceName = deviceName;
        this.deviceLabel = deviceLabel;
        this.deviceType = deviceType;
        this.deviceCustomerId = deviceCustomerId;
    }

    public static class DeviceActivityNotificationInfoBuilder {
        private String eventType;
        private UUID deviceId;
        private String deviceName;
        private String deviceLabel;
        private String deviceType;
        private CustomerId deviceCustomerId;

        DeviceActivityNotificationInfoBuilder() {
        }

        public DeviceActivityNotificationInfoBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public DeviceActivityNotificationInfoBuilder deviceId(UUID deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DeviceActivityNotificationInfoBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceActivityNotificationInfoBuilder deviceLabel(String deviceLabel) {
            this.deviceLabel = deviceLabel;
            return this;
        }

        public DeviceActivityNotificationInfoBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceActivityNotificationInfoBuilder deviceCustomerId(CustomerId deviceCustomerId) {
            this.deviceCustomerId = deviceCustomerId;
            return this;
        }

        public DeviceActivityNotificationInfo build() {
            return new DeviceActivityNotificationInfo(this.eventType, this.deviceId, this.deviceName, this.deviceLabel, this.deviceType, this.deviceCustomerId);
        }

        public String toString() {
            return "DeviceActivityNotificationInfo.DeviceActivityNotificationInfoBuilder(eventType=" + this.eventType + ", deviceId=" + this.deviceId + ", deviceName=" + this.deviceName + ", deviceLabel=" + this.deviceLabel + ", deviceType=" + this.deviceType + ", deviceCustomerId=" + this.deviceCustomerId + ")";
        }
    }
}

