/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel
public class CustomMenuItem {
    @ApiModelProperty(position=1, value="Name of the menu item", example="My Custom Menu", required=true)
    private String name;
    @ApiModelProperty(position=2, value="URL of the menu item icon. Overrides 'materialIcon'", example="My Custom Menu")
    private String iconUrl;
    @ApiModelProperty(position=3, value="Material icon name. See [Material Icons](https://fonts.google.com/icons?selected=Material+Icons) for examples", example="Info")
    private String materialIcon;
    @ApiModelProperty(position=4, value="URL to open in the iframe, when user clicks the menu item", example="https://myexternalurl.com")
    private String iframeUrl;
    @ApiModelProperty(position=5, value="Id of the Dashboard to open, when user clicks the menu item", example="https://mycompany.com")
    private String dashboardId;
    @ApiModelProperty(position=6, value="Hide the dashboard toolbar")
    private Boolean hideDashboardToolbar;
    @ApiModelProperty(position=7, value="Set the access token of the current user to a new dashboard")
    private boolean setAccessToken;
    @ApiModelProperty(position=8, value="List of child menu items")
    private List<CustomMenuItem> childMenuItems = new ArrayList<CustomMenuItem>();

    public String getName() {
        return this.name;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getMaterialIcon() {
        return this.materialIcon;
    }

    public String getIframeUrl() {
        return this.iframeUrl;
    }

    public String getDashboardId() {
        return this.dashboardId;
    }

    public Boolean getHideDashboardToolbar() {
        return this.hideDashboardToolbar;
    }

    public boolean isSetAccessToken() {
        return this.setAccessToken;
    }

    public List<CustomMenuItem> getChildMenuItems() {
        return this.childMenuItems;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setMaterialIcon(String materialIcon) {
        this.materialIcon = materialIcon;
    }

    public void setIframeUrl(String iframeUrl) {
        this.iframeUrl = iframeUrl;
    }

    public void setDashboardId(String dashboardId) {
        this.dashboardId = dashboardId;
    }

    public void setHideDashboardToolbar(Boolean hideDashboardToolbar) {
        this.hideDashboardToolbar = hideDashboardToolbar;
    }

    public void setSetAccessToken(boolean setAccessToken) {
        this.setAccessToken = setAccessToken;
    }

    public void setChildMenuItems(List<CustomMenuItem> childMenuItems) {
        this.childMenuItems = childMenuItems;
    }

    public String toString() {
        return "CustomMenuItem(name=" + this.getName() + ", iconUrl=" + this.getIconUrl() + ", materialIcon=" + this.getMaterialIcon() + ", iframeUrl=" + this.getIframeUrl() + ", dashboardId=" + this.getDashboardId() + ", hideDashboardToolbar=" + this.getHideDashboardToolbar() + ", setAccessToken=" + this.isSetAccessToken() + ", childMenuItems=" + this.getChildMenuItems() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomMenuItem)) {
            return false;
        }
        CustomMenuItem other = (CustomMenuItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSetAccessToken() != other.isSetAccessToken()) {
            return false;
        }
        Boolean this$hideDashboardToolbar = this.getHideDashboardToolbar();
        Boolean other$hideDashboardToolbar = other.getHideDashboardToolbar();
        if (this$hideDashboardToolbar == null ? other$hideDashboardToolbar != null : !((Object)this$hideDashboardToolbar).equals(other$hideDashboardToolbar)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$iconUrl = this.getIconUrl();
        String other$iconUrl = other.getIconUrl();
        if (this$iconUrl == null ? other$iconUrl != null : !this$iconUrl.equals(other$iconUrl)) {
            return false;
        }
        String this$materialIcon = this.getMaterialIcon();
        String other$materialIcon = other.getMaterialIcon();
        if (this$materialIcon == null ? other$materialIcon != null : !this$materialIcon.equals(other$materialIcon)) {
            return false;
        }
        String this$iframeUrl = this.getIframeUrl();
        String other$iframeUrl = other.getIframeUrl();
        if (this$iframeUrl == null ? other$iframeUrl != null : !this$iframeUrl.equals(other$iframeUrl)) {
            return false;
        }
        String this$dashboardId = this.getDashboardId();
        String other$dashboardId = other.getDashboardId();
        if (this$dashboardId == null ? other$dashboardId != null : !this$dashboardId.equals(other$dashboardId)) {
            return false;
        }
        List<CustomMenuItem> this$childMenuItems = this.getChildMenuItems();
        List<CustomMenuItem> other$childMenuItems = other.getChildMenuItems();
        return !(this$childMenuItems == null ? other$childMenuItems != null : !((Object)this$childMenuItems).equals(other$childMenuItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomMenuItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSetAccessToken() ? 79 : 97);
        Boolean $hideDashboardToolbar = this.getHideDashboardToolbar();
        result = result * 59 + ($hideDashboardToolbar == null ? 43 : ((Object)$hideDashboardToolbar).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $iconUrl = this.getIconUrl();
        result = result * 59 + ($iconUrl == null ? 43 : $iconUrl.hashCode());
        String $materialIcon = this.getMaterialIcon();
        result = result * 59 + ($materialIcon == null ? 43 : $materialIcon.hashCode());
        String $iframeUrl = this.getIframeUrl();
        result = result * 59 + ($iframeUrl == null ? 43 : $iframeUrl.hashCode());
        String $dashboardId = this.getDashboardId();
        result = result * 59 + ($dashboardId == null ? 43 : $dashboardId.hashCode());
        List<CustomMenuItem> $childMenuItems = this.getChildMenuItems();
        result = result * 59 + ($childMenuItems == null ? 43 : ((Object)$childMenuItems).hashCode());
        return result;
    }
}

